/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.hudwidget;

import net.labymod.addons.minimap.MinimapAddon;
import net.labymod.addons.minimap.api.event.MinimapRenderEvent;
import net.labymod.addons.minimap.api.map.MinimapBounds;
import net.labymod.addons.minimap.api.map.MinimapCardinalType;
import net.labymod.addons.minimap.api.map.MinimapCircle;
import net.labymod.addons.minimap.api.map.MinimapDisplayType;
import net.labymod.addons.minimap.api.map.MinimapPlayerIcon;
import net.labymod.addons.minimap.map.v2.MinimapRenderer;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.gfx.pipeline.RenderAttributes;
import net.labymod.api.client.gfx.pipeline.RenderAttributesStack;
import net.labymod.api.client.gui.hud.binding.category.HudWidgetCategory;
import net.labymod.api.client.gui.hud.hudwidget.HudWidget;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.widget.widgets.hud.HudWidgetWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.util.Color;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.position.Position;
import org.jetbrains.annotations.Nullable;

@SpriteSlot(size=32)
public class MinimapHudWidget
extends HudWidget<MinimapHudWidgetConfig> {
    private static final float DEFAULT_MINIMAP_WIDTH = 150.0f;
    private static final float DEFAULT_MINIMAP_HEIGHT = 150.0f;
    private static final float DEFAULT_TEXT_LINE_HEIGHT = 10.0f;
    private final MinimapRenderEvent renderEvent = new MinimapRenderEvent();
    private final MinimapAddon addon;
    private final MinimapCircle circle = new MinimapCircle();
    private final MinimapRenderer renderer;
    private float distanceToCorner = 0.0f;
    private float lastRadius = 0.0f;

    public MinimapHudWidget(MinimapAddon addon, MinimapRenderer renderer) {
        super("minimap", MinimapHudWidgetConfig.class);
        this.bindCategory(HudWidgetCategory.INGAME);
        this.addon = addon;
        this.renderer = renderer;
    }

    public boolean isVisibleInGame() {
        return this.addon.isMinimapAllowed();
    }

    public void load(MinimapHudWidgetConfig config) {
        super.load((HudWidgetConfig)config);
    }

    public void updateSize(HudWidgetWidget widget, boolean isEditorContext, HudSize size) {
        size.set(150.0f, 150.0f);
        if (((Boolean)((MinimapHudWidgetConfig)this.config).showCoordinates().get()).booleanValue()) {
            size.set(150.0f, 160.0f);
        }
    }

    public void render(ScreenContext context, boolean isEditorContext, HudSize size) {
        HudSize newHudSize = size;
        boolean showCoordinates = (Boolean)((MinimapHudWidgetConfig)this.config).showCoordinates().get();
        if (showCoordinates) {
            newHudSize = newHudSize.copy();
            newHudSize.setHeight(newHudSize.getActualHeight() - 10.0f);
        }
        if (!this.labyAPI.minecraft().isIngame()) {
            context.pushStack();
            context.translate(newHudSize.getActualWidth() / 2.0f, newHudSize.getActualHeight() / 2.0f, 0.0f);
            context.scale(0.95f, 0.95f, 1.0f);
            context.translate(-newHudSize.getActualWidth() / 2.0f, -newHudSize.getActualHeight() / 2.0f, 0.0f);
            this.renderMapOutline(context, newHudSize, MinimapDisplayType.Stage.BEFORE_TEXTURE);
            RenderAttributesStack renderAttributesStack = Laby.references().renderEnvironmentContext().renderAttributesStack();
            float radius = newHudSize.getActualWidth() / 2.0f;
            RenderAttributes renderAttributes = renderAttributesStack.pushAndGet();
            renderAttributes.setStencilMode(RenderAttributes.StencilMode.WRITE_STENCIL);
            MinimapHudWidgetConfig configuration = this.configuration();
            ((MinimapDisplayType)((Object)configuration.displayType().get())).renderStencil(context, radius);
            renderAttributes.setStencilMode(RenderAttributes.StencilMode.WRITE_TO_STENCIL);
            context.pushStack();
            if (this.lastRadius != radius) {
                this.distanceToCorner = (float)Math.sqrt(radius * radius + radius * radius);
                this.lastRadius = radius;
            }
            int zoomBlocks = (Integer)this.configuration().zoom().get() * 10;
            float pixelsPerBlock = size.getActualWidth() / ((float)zoomBlocks * 0.5f);
            context.pushStack();
            context.translate(newHudSize.getActualWidth() / 2.0f, newHudSize.getActualHeight() / 2.0f, 0.0f);
            context.scale(pixelsPerBlock, pixelsPerBlock, 1.0f);
            context.translate(-newHudSize.getActualWidth() / 2.0f, -newHudSize.getActualHeight() / 2.0f, 0.0f);
            this.renderer.renderDummyMinimap(context, 0.0f, 0.0f, newHudSize.getActualWidth(), newHudSize.getActualHeight());
            context.popStack();
            context.popStack();
            renderAttributesStack.pop();
            this.renderMapOutline(context, newHudSize, MinimapDisplayType.Stage.AFTER_TEXTURE);
            context.popStack();
            return;
        }
        ClientPlayer player = this.labyAPI.minecraft().getClientPlayer();
        if (player == null) {
            return;
        }
        Position position = player.position();
        ScreenCanvas canvas = context.canvas();
        if (showCoordinates) {
            String coordinatesText = "X: " + MathHelper.floor((double)position.getX()) + " Y: " + MathHelper.floor((double)position.getY()) + " Z: " + MathHelper.floor((double)position.getZ());
            canvas.submitText(coordinatesText, newHudSize.getActualWidth() / 2.0f, newHudSize.getActualHeight(), -1, 1.0f, 3);
        }
        context.pushStack();
        context.translate(newHudSize.getActualWidth() / 2.0f, newHudSize.getActualHeight() / 2.0f, 0.0f);
        context.scale(0.95f, 0.95f, 1.0f);
        context.translate(-newHudSize.getActualWidth() / 2.0f, -newHudSize.getActualHeight() / 2.0f, 0.0f);
        float radius = newHudSize.getActualWidth() / 2.0f;
        if (this.lastRadius != radius) {
            this.distanceToCorner = (float)Math.sqrt(radius * radius + radius * radius);
            this.lastRadius = radius;
        }
        this.renderEvent.fill(context, newHudSize, new MinimapBounds(), this.circle);
        MinimapHudWidgetConfig configuration = this.configuration();
        this.circle.init((MinimapDisplayType)((Object)configuration.displayType().get()), newHudSize, this.distanceToCorner);
        this.renderMapOutline(context, newHudSize, MinimapDisplayType.Stage.BEFORE_TEXTURE);
        RenderAttributesStack renderAttributesStack = Laby.references().renderEnvironmentContext().renderAttributesStack();
        RenderAttributes renderAttributes = renderAttributesStack.pushAndGet();
        renderAttributes.setStencilMode(RenderAttributes.StencilMode.WRITE_STENCIL);
        ((MinimapDisplayType)((Object)configuration.displayType().get())).renderStencil(context, radius);
        renderAttributes.setStencilMode(RenderAttributes.StencilMode.WRITE_TO_STENCIL);
        if (this.addon.isMinimapAllowed()) {
            context.pushStack();
            this.applyZoom(player, context, newHudSize, true);
            this.renderMapTexture(player, context, newHudSize);
            this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.ROTATED_STENCIL);
            context.popStack();
        }
        context.pushStack();
        this.applyZoom(player, context, newHudSize, false);
        this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.STRAIGHT_ZOOMED_STENCIL);
        context.popStack();
        this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.STRAIGHT_NORMAL_STENCIL);
        renderAttributesStack.pop();
        this.renderMapOutline(context, newHudSize, MinimapDisplayType.Stage.AFTER_TEXTURE);
        if (configuration.cardinalType().get() != MinimapCardinalType.HIDDEN) {
            this.renderCardinals(player, context);
        }
        if (this.addon.isMinimapAllowed()) {
            context.pushStack();
            this.applyZoom(player, context, newHudSize, true);
            this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.ROTATED);
            context.popStack();
        }
        context.pushStack();
        this.applyZoom(player, context, newHudSize, false);
        this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.STRAIGHT_ZOOMED);
        context.popStack();
        this.renderEvent.fireWithStage(MinimapRenderEvent.Stage.STRAIGHT_NORMAL);
        context.popStack();
    }

    public void onTick(boolean isEditorContext) {
        super.onTick(isEditorContext);
        this.renderer.tick();
    }

    private void applyZoom(@Nullable ClientPlayer player, ScreenContext context, HudSize size, boolean rotate) {
        Stack stack = context.stack();
        double addZoom = (double)(this.distanceToCorner / this.lastRadius) + 0.3;
        MinimapHudWidgetConfig configuration = this.configuration();
        if (player != null) {
            Position position = player.position();
            Position previousPosition = player.previousPosition();
            if (((Boolean)configuration.jumpBouncing().get()).booleanValue()) {
                addZoom += (previousPosition.getY() - position.getY()) / 20.0;
            }
        }
        stack.translate(size.getActualWidth() / 2.0f, size.getActualHeight() / 2.0f, 0.0f);
        if (rotate) {
            stack.scale(-1.0f, -1.0f, 1.0f);
            if (player != null) {
                stack.rotate(-player.getRotationHeadYaw(), 0.0f, 0.0f, 1.0f);
            }
        }
        stack.scale((float)addZoom, (float)addZoom, 1.0f);
        stack.translate(-size.getActualWidth() / 2.0f, -size.getActualHeight() / 2.0f, 0.0f);
        this.renderEvent.setZoom((float)addZoom);
    }

    private void renderMapTexture(ClientPlayer player, ScreenContext context, HudSize size) {
        Stack stack = context.stack();
        MinimapBounds bounds = this.renderer.minimapBounds();
        float mapMidX = (float)bounds.getX1() + (float)(bounds.getX2() - bounds.getX1()) / 2.0f;
        float mapMidZ = (float)bounds.getZ1() + (float)(bounds.getZ2() - bounds.getZ1()) / 2.0f;
        Position position = player.position();
        Position previousPosition = player.previousPosition();
        double smoothX = position.lerpX(previousPosition, context.getTickDelta());
        double smoothZ = position.lerpZ(previousPosition, context.getTickDelta());
        double dx = smoothX - (double)mapMidX;
        double dz = smoothZ - (double)mapMidZ;
        int zoomBlocks = (Integer)this.configuration().zoom().get() * 10;
        float pixelsPerBlock = size.getActualWidth() / ((float)zoomBlocks * 2.0f);
        this.renderEvent.setPixelLength(pixelsPerBlock);
        double offsetX = (double)(-pixelsPerBlock) * dx;
        double offsetY = (double)pixelsPerBlock * dz;
        float pixelNudgeX = -0.4f;
        float pixelNudgeY = -0.4f;
        stack.push();
        stack.translate((float)((double)pixelNudgeX + offsetX), (float)(-((double)pixelNudgeY + offsetY)), 0.0f);
        this.renderer.render(context, 0.0f, 0.0f, size.getActualWidth(), size.getActualHeight());
        stack.pop();
    }

    private void renderMapOutline(ScreenContext context, HudSize size, MinimapDisplayType.Stage stage) {
        MinimapHudWidgetConfig configuration = this.configuration();
        MinimapDisplayType displayType = (MinimapDisplayType)((Object)configuration.displayType().get());
        if (stage != null && displayType.stage() != stage) {
            return;
        }
        context.canvas().submitIcon(displayType.icon(), -5.0f, -5.0f, size.getActualWidth() + 10.0f, size.getActualHeight() + 10.0f);
    }

    private void renderCardinals(ClientPlayer player, ScreenContext context) {
        String[] stringArray;
        boolean numbers;
        MinimapHudWidgetConfig configuration = this.configuration();
        MinimapCardinalType type = (MinimapCardinalType)((Object)configuration.cardinalType().get());
        boolean bl = numbers = type == MinimapCardinalType.NUMBERS;
        if (numbers) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "2";
            stringArray2[1] = "3";
            stringArray2[2] = "0";
            stringArray = stringArray2;
            stringArray2[3] = "1";
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = "N";
            stringArray3[1] = "NE";
            stringArray3[2] = "E";
            stringArray3[3] = "SE";
            stringArray3[4] = "S";
            stringArray3[5] = "SW";
            stringArray3[6] = "W";
            stringArray = stringArray3;
            stringArray3[7] = "NW";
        }
        String[] cardinals = stringArray;
        float yaw = player.getRotationHeadYaw();
        int index = 1;
        for (String cardinal : cardinals) {
            double f = Math.PI / 360 * (double)((yaw - (float)(index * (numbers ? 90 : 45))) % 360.0f - (float)(numbers ? 0 : 45)) * 2.0;
            this.circle.calculate(f);
            if (numbers || index % 2 == 1 || type == MinimapCardinalType.EXTENDED) {
                context.canvas().submitText(cardinal, this.circle.getCircleX() - 2.0f, this.circle.getCircleY() - 4.0f, -1, 1.0f, 1);
            }
            ++index;
        }
    }

    private MinimapHudWidgetConfig configuration() {
        return (MinimapHudWidgetConfig)this.getConfig();
    }

    public static class MinimapHudWidgetConfig
    extends HudWidgetConfig
    implements net.labymod.addons.minimap.api.config.MinimapHudWidgetConfig {
        @DropdownWidget.DropdownEntryTranslationPrefix(value="labysminimap.hudWidget.minimap.displayType.entries")
        @DropdownWidget.DropdownSetting
        private final ConfigProperty<MinimapDisplayType> displayType = ConfigProperty.createEnum((Enum)MinimapDisplayType.ROUND_FUTURE_THIN);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> jumpBouncing = ConfigProperty.create((Object)false);
        @SliderWidget.SliderSetting(min=2.0f, max=30.0f)
        private final ConfigProperty<Integer> zoom = ConfigProperty.create((Object)12);
        @DropdownWidget.DropdownSetting
        @DropdownWidget.DropdownEntryTranslationPrefix(value="labysminimap.hudWidget.minimap.cardinalType.entries")
        private final ConfigProperty<MinimapCardinalType> cardinalType = ConfigProperty.create((Object)((Object)MinimapCardinalType.NORMAL));
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showCoordinates = ConfigProperty.create((Object)false);
        @SettingSection(value="tiles")
        @SliderWidget.SliderSetting(min=4.0f, max=16.0f)
        private final ConfigProperty<Integer> tileSize = ConfigProperty.create((Object)12);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showOwnPlayer = ConfigProperty.create((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showPlayers = ConfigProperty.create((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showWaypoints = ConfigProperty.create((Object)true);
        @SettingSection(value="player")
        @DropdownWidget.DropdownSetting
        private final ConfigProperty<MinimapPlayerIcon> playerIcon = ConfigProperty.create((Object)((Object)MinimapPlayerIcon.TRIANGLE));
        @ColorPickerWidget.ColorPickerSetting(alpha=true, chroma=true)
        private final ConfigProperty<Color> playerColor = ConfigProperty.create((Object)Color.WHITE);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> caveMode = ConfigProperty.create((Object)false);

        @Override
        public ConfigProperty<MinimapDisplayType> displayType() {
            return this.displayType;
        }

        @Override
        public ConfigProperty<Boolean> jumpBouncing() {
            return this.jumpBouncing;
        }

        @Override
        public ConfigProperty<Integer> zoom() {
            return this.zoom;
        }

        public ConfigProperty<Boolean> showCoordinates() {
            return this.showCoordinates;
        }

        @Override
        public ConfigProperty<Integer> tileSize() {
            return this.tileSize;
        }

        @Override
        public ConfigProperty<Boolean> showOwnPlayer() {
            return this.showOwnPlayer;
        }

        @Override
        public ConfigProperty<Boolean> showPlayers() {
            return this.showPlayers;
        }

        @Override
        public ConfigProperty<Boolean> showWaypoints() {
            return this.showWaypoints;
        }

        @Override
        public ConfigProperty<MinimapCardinalType> cardinalType() {
            return this.cardinalType;
        }

        @Override
        public ConfigProperty<MinimapPlayerIcon> playerIcon() {
            return this.playerIcon;
        }

        @Override
        public ConfigProperty<Color> playerColor() {
            return this.playerColor;
        }

        @Override
        public ConfigProperty<Boolean> caveMode() {
            return this.caveMode;
        }
    }
}

