/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.layout;

import net.labymod.addons.waypoints.core.activity.layout.WaypointCollection;
import net.labymod.addons.waypoints.waypoint.WaypointContext;
import net.labymod.api.Textures;
import net.labymod.api.client.gui.icon.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaypointContextCollection
extends WaypointCollection {
    private final WaypointContext context;
    private final String contextValue;

    public WaypointContextCollection(@Nullable WaypointContext context, @Nullable String contextValue) {
        super(WaypointContextCollection.getIconByContext(context, contextValue), WaypointContextCollection.getNameByContext(contextValue));
        this.context = context;
        this.contextValue = contextValue;
    }

    @NotNull
    private static Icon getIconByContext(@Nullable WaypointContext context, @Nullable String contextValue) {
        if (context == WaypointContext.MULTI_PLAYER) {
            if (contextValue == null) {
                throw new IllegalArgumentException("The context value cannot be null when the context is multi player!");
            }
            return Icon.server((String)contextValue);
        }
        if (contextValue == null) {
            return Textures.SpriteCommon.CIRCLE_WARNING;
        }
        return Icon.defaultServer();
    }

    @NotNull
    private static String getNameByContext(@Nullable String contextValue) {
        return contextValue == null ? "unknown (deprecated, visible on every world)" : contextValue;
    }

    @NotNull
    public WaypointContext context() {
        return this.context;
    }

    @NotNull
    public String getContextValue() {
        return this.contextValue;
    }
}

