/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.waypoint;

import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.network.server.ServerAddress;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.util.Color;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.math.vector.FloatVector3;
import org.jetbrains.annotations.NotNull;

@Referenceable
public interface WaypointBuilder {
    @Deprecated
    public static WaypointBuilder newBuilder() {
        return Waypoints.references().waypointBuilder();
    }

    @NotNull
    public static WaypointBuilder create() {
        return Waypoints.references().waypointBuilder();
    }

    @NotNull
    default public WaypointBuilder identifierPrefix(String prefix) {
        return this.identifier(Waypoints.references().waypointService().generateUniqueIdentifier(prefix));
    }

    @NotNull
    public WaypointBuilder identifier(String var1);

    @NotNull
    public WaypointBuilder title(Component var1);

    @NotNull
    public WaypointBuilder color(Color var1);

    @NotNull
    public WaypointBuilder icon(Icon var1);

    @NotNull
    public WaypointBuilder type(WaypointType var1);

    @NotNull
    public WaypointBuilder location(DoubleVector3 var1);

    @NotNull
    public WaypointBuilder visible(boolean var1);

    @NotNull
    public WaypointBuilder singlePlayer(String var1);

    @NotNull
    public WaypointBuilder server(ServerAddress var1);

    @NotNull
    public WaypointBuilder dimension(String var1);

    @NotNull
    public WaypointMeta build();

    @Deprecated
    @NotNull
    default public WaypointBuilder location(FloatVector3 location) {
        return this.location(new DoubleVector3((double)location.getX(), (double)location.getY(), (double)location.getZ()));
    }

    @NotNull
    default public WaypointBuilder server() {
        ServerAddress currentServer = Waypoints.references().waypointService().getServerAddress();
        if (currentServer == null) {
            throw new IllegalStateException("Player is not on a server");
        }
        return this.server(currentServer);
    }

    @NotNull
    default public WaypointBuilder singlePlayer() {
        String currentWorld = Waypoints.references().waypointService().getSinglePlayerWorld();
        if (currentWorld == null) {
            throw new IllegalStateException("Player is not in single player");
        }
        return this.singlePlayer(currentWorld);
    }

    @NotNull
    default public WaypointBuilder applyCurrentContext() {
        WaypointService waypointService = Waypoints.references().waypointService();
        if (waypointService.getServerAddress() != null) {
            return this.server(waypointService.getServerAddress());
        }
        String singlePlayerWorld = waypointService.getSinglePlayerWorld();
        if (singlePlayerWorld != null) {
            return this.singlePlayer(singlePlayerWorld);
        }
        throw new IllegalStateException("Player is not in single player or on a server");
    }

    @NotNull
    default public WaypointBuilder currentDimension() {
        String dimension = Waypoints.references().waypointService().getDimension();
        if (dimension == null) {
            throw new IllegalStateException("Player is not in a dimension");
        }
        return this.dimension(dimension);
    }

    @Deprecated
    @NotNull
    default public WaypointBuilder server(String server) {
        return this.server(ServerAddress.parse((String)server));
    }

    @Deprecated
    @NotNull
    default public WaypointBuilder world(String world) {
        return this.singlePlayer(world);
    }
}

