/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.waypoint;

import java.util.Objects;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.waypoint.WaypointContext;
import net.labymod.addons.waypoints.waypoint.WaypointIcon;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.util.Color;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.math.vector.FloatVector3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaypointMeta {
    private final String id;
    @Nullable
    private final WaypointContext contextType;
    @Nullable
    private final String context;
    private final WaypointType type;
    private String dimension;
    private Component title;
    private Color color;
    private DoubleVector3 location;
    private Icon icon;
    private boolean visible;

    @ApiStatus.Internal
    public WaypointMeta(@NotNull String id, @NotNull Component title, @NotNull Color color, @NotNull WaypointType type, @NotNull DoubleVector3 location, @Nullable WaypointContext contextType, @Nullable String context, @NotNull Icon icon, @Nullable String dimension, boolean visible) {
        this.id = id;
        this.title = title;
        this.color = color;
        this.type = type;
        this.location = location;
        this.visible = visible;
        this.contextType = contextType;
        this.context = context;
        this.icon = icon;
        this.dimension = dimension;
    }

    @Deprecated
    @ApiStatus.Internal
    public WaypointMeta(@NotNull Component title, @NotNull Color color, @NotNull WaypointType type, @NotNull FloatVector3 location, boolean visible, @Nullable String world, @NotNull String server, @NotNull String dimension) {
        this(Waypoints.references().waypointService().generateUniqueIdentifier(), title, color, type, new DoubleVector3((double)location.getX(), (double)location.getY(), (double)location.getZ()), world == null ? WaypointContext.MULTI_PLAYER : WaypointContext.SINGLE_PLAYER, world == null ? server : world, WaypointIcon.DEFAULT, dimension, visible);
    }

    @NotNull
    public String getIdentifier() {
        return this.id;
    }

    @NotNull
    public Component title() {
        return this.title;
    }

    @Deprecated
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull Component title) {
        Objects.requireNonNull(title, "Title cannot be null");
        this.title = title;
    }

    @NotNull
    public Color color() {
        return this.color;
    }

    public int iconColor() {
        if (this.icon == WaypointIcon.DEFAULT) {
            return this.color.get();
        }
        return -1;
    }

    @Deprecated
    public Color getColor() {
        return this.color;
    }

    public void setColor(@NotNull Color color) {
        Objects.requireNonNull(color, "Color cannot be null");
        this.color = color;
    }

    @NotNull
    public WaypointType type() {
        return this.type;
    }

    @Deprecated
    public WaypointType getType() {
        return this.type;
    }

    @Deprecated
    public void setType(@NotNull WaypointType type) {
    }

    @NotNull
    public Icon icon() {
        if (this.icon == null) {
            this.icon = WaypointIcon.DEFAULT;
        }
        return this.icon;
    }

    public void setIcon(@NotNull Icon icon) {
        this.icon = icon;
    }

    @NotNull
    public DoubleVector3 location() {
        return this.location;
    }

    @Deprecated
    public FloatVector3 getLocation() {
        return new FloatVector3((float)this.location.getX(), (float)this.location.getY(), (float)this.location.getZ());
    }

    public void setLocation(@NotNull DoubleVector3 location) {
        this.location = location;
    }

    @Deprecated
    public void setLocation(FloatVector3 location) {
        this.location = new DoubleVector3((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            Waypoints.refresh();
        }
    }

    @Nullable
    public WaypointContext contextType() {
        return this.contextType;
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    public boolean matchesContext(@Nullable WaypointContext type, @Nullable String value) {
        return Objects.equals(value, this.context) && type == this.contextType;
    }

    @Deprecated
    @Nullable
    public String getWorld() {
        return this.contextType == WaypointContext.MULTI_PLAYER ? null : this.context;
    }

    @Nullable
    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(@NotNull String dimension) {
        this.dimension = dimension;
        Waypoints.refresh();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WaypointMeta)) {
            return false;
        }
        WaypointMeta that = (WaypointMeta)object;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public WaypointMeta copy() {
        return new WaypointMeta(this.id, this.title.copy(), this.color, this.type, this.location.copy(), this.contextType, this.context, this.icon, this.dimension, this.visible);
    }
}

