/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.waypoint;

import java.util.EnumMap;
import net.labymod.addons.waypoints.WaypointConfigurationStorage;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.utils.DistanceFormatting;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.math.vector.FloatVector3;

public class WaypointObjectMeta {
    private static final WaypointConfigurationStorage CONFIGURATION_STORAGE = Waypoints.references().waypointService().configurationStorage();
    private final WaypointMeta meta;
    private final DoubleVector3 position;
    private final EnumMap<Type, Component> cache = new EnumMap(Type.class);
    private float scale = 0.0f;
    private double distanceToPlayer;
    private boolean outOfRange;
    private boolean interpolatePosition = false;
    private float alpha = 1.0f;

    public WaypointObjectMeta(WaypointMeta meta) {
        this.meta = meta;
        this.position = meta.location().copy();
    }

    public DoubleVector3 pos() {
        return this.position;
    }

    @Deprecated
    public FloatVector3 position() {
        return new FloatVector3((float)this.position.getX(), (float)this.position.getY(), (float)this.position.getZ());
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public double getDistance() {
        return this.distanceToPlayer;
    }

    public void setDistance(double distanceToPlayer) {
        this.clearTitleCache();
        this.distanceToPlayer = distanceToPlayer;
    }

    @Deprecated
    public void setDistance(float distanceToPlayer) {
        this.setDistance((double)distanceToPlayer);
    }

    public boolean isInterpolatePosition() {
        return this.interpolatePosition;
    }

    public void setInterpolatePosition(boolean interpolatePosition) {
        this.interpolatePosition = interpolatePosition;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Deprecated
    public float getDistanceToPlayer() {
        return (float)this.distanceToPlayer;
    }

    public boolean isOutOfRange() {
        return this.outOfRange;
    }

    public void setOutOfRange(boolean outOfRange) {
        this.outOfRange = outOfRange;
    }

    public void clearTitleCache() {
        this.cache.clear();
    }

    public Component formatTitle(Type type) {
        Component cachedTitle = this.cache.get((Object)type);
        if (cachedTitle != null) {
            return cachedTitle;
        }
        boolean before = CONFIGURATION_STORAGE.isDistanceBeforeName();
        TextComponent title = Component.text((String)"", (TextColor)(type == Type.WITHOUT_COLOR ? NamedTextColor.WHITE : TextColor.color((int)this.meta.color().get())));
        if (before && !CONFIGURATION_STORAGE.isHideDistance()) {
            title.append(this.createDistanceComponent(true, false));
        }
        title.append(this.meta.title());
        if (!before && !CONFIGURATION_STORAGE.isHideDistance()) {
            title.append(this.createDistanceComponent(true, true));
        }
        this.cache.put(type, (Component)title);
        return title;
    }

    public Component createDistanceComponent(boolean withSpace, boolean after) {
        String distanceString;
        long distanceToPlayer = Math.round(this.distanceToPlayer);
        if (CONFIGURATION_STORAGE.isConvertToKilometers() && distanceToPlayer >= (long)CONFIGURATION_STORAGE.getKilometersThreshold()) {
            double kilometers = (double)distanceToPlayer / 1000.0;
            double roundedKilometers = distanceToPlayer > 2500L ? (double)Math.round(kilometers * 10.0) / 10.0 : (double)Math.round(kilometers * 100.0) / 100.0;
            distanceString = roundedKilometers + "km";
        } else {
            distanceString = distanceToPlayer + "m";
        }
        TextComponent distanceComponent = Component.text((String)distanceString, (TextColor)CONFIGURATION_STORAGE.distanceValueColor());
        Component component = CONFIGURATION_STORAGE.distanceFormatting().build((Component)distanceComponent, after).color(CONFIGURATION_STORAGE.distanceBracketColor());
        if (withSpace) {
            if (after) {
                component.append(0, DistanceFormatting.space());
            } else {
                component.append(DistanceFormatting.space());
            }
        }
        return component;
    }

    public Component createDistanceComponent() {
        return this.createDistanceComponent(false, true);
    }

    public static enum Type {
        WITH_COLOR,
        WITHOUT_COLOR;

    }
}

