/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core;

import net.labymod.api.laby3d.pipeline.RenderStates;
import net.labymod.api.laby3d.vertex.VertexDescriptions;
import net.labymod.laby3d.api.pipeline.ComparisonStrategy;
import net.labymod.laby3d.api.pipeline.DrawingMode;
import net.labymod.laby3d.api.pipeline.RenderState;
import net.labymod.laby3d.api.pipeline.blend.DefaultBlendFunctions;
import net.labymod.laby3d.api.pipeline.shader.ShaderProgramDescription;
import net.labymod.laby3d.api.pipeline.shader.UniformSamplerDescription;
import net.labymod.laby3d.api.resource.AssetId;

public final class WaypointsRenderPrograms {
    public static final ShaderProgramDescription SHADER = ShaderProgramDescription.builder((ShaderProgramDescription.Snippet[])new ShaderProgramDescription.Snippet[]{RenderStates.DEFAULT_SHADER_SNIPPET}).setId(WaypointsRenderPrograms.buildProgramId("background")).setVertexShader((AssetId)RenderStates.SHADER_RESOLVER.apply("core/simple_level_geometry.vsh")).setFragmentShader((AssetId)RenderStates.SHADER_RESOLVER.apply("core/simple_level_geometry.fsh")).addSampler(new UniformSamplerDescription("DiffuseSampler", 0)).build();
    public static final RenderState BACKGROUND = RenderState.builder((RenderState.Snippet[])new RenderState.Snippet[0]).setId(WaypointsRenderPrograms.buildStateId("background")).setVertexDescription(VertexDescriptions.POSITION_UV_COLOR).setBlendFunction(DefaultBlendFunctions.TRANSLUCENT).setDepthTestStrategy(ComparisonStrategy.NEVER).setShaderProgramDescription(SHADER).setDrawingMode(DrawingMode.QUADS).build();
    public static final RenderState ICON = RenderState.builder((RenderState.Snippet[])new RenderState.Snippet[0]).setId(WaypointsRenderPrograms.buildStateId("icon")).setVertexDescription(VertexDescriptions.POSITION_UV_COLOR).setBlendFunction(DefaultBlendFunctions.TRANSLUCENT).setDepthTestStrategy(ComparisonStrategy.NEVER).setShaderProgramDescription(SHADER).setDrawingMode(DrawingMode.QUADS).build();
    public static final RenderState BEACON_BEAM = RenderState.builder((RenderState.Snippet[])new RenderState.Snippet[0]).setId(WaypointsRenderPrograms.buildStateId("beacon_beam")).setVertexDescription(VertexDescriptions.POSITION_UV_COLOR).setBlendFunction(DefaultBlendFunctions.TRANSLUCENT).setCull(false).setShaderProgramDescription(SHADER).setDrawingMode(DrawingMode.QUADS).build();

    private static AssetId buildStateId(String name) {
        return AssetId.of((String)"labyswaypoints", (String)("renderstate/" + name));
    }

    private static AssetId buildProgramId(String name) {
        return AssetId.of((String)"labyswaypoints", (String)("shaderprogram/" + name));
    }
}

