/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.layout;

import java.util.ArrayList;
import java.util.List;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.api.client.gui.icon.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WaypointCollection {
    private final List<Object> entries = new ArrayList<Object>();
    private final Icon icon;
    private final String name;
    private WaypointCollection parent;

    protected WaypointCollection(@NotNull Icon icon, @NotNull String name) {
        this.icon = icon;
        this.name = name;
    }

    @NotNull
    public Icon icon() {
        return this.icon;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Object> getEntries() {
        return this.entries;
    }

    @Nullable
    public WaypointCollection getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void add(Waypoint waypoint) {
        this.entries.add(waypoint);
    }

    public void add(WaypointCollection collection) {
        if (collection == this) {
            throw new IllegalArgumentException("Cannot add collection to itself");
        }
        this.entries.add(collection);
        collection.parent = this;
    }

    public void sort() {
        this.entries.sort((a, b) -> {
            if (a instanceof WaypointCollection && b instanceof Waypoint) {
                return -1;
            }
            if (a instanceof Waypoint && b instanceof WaypointCollection) {
                return 1;
            }
            if (a instanceof WaypointCollection) {
                WaypointCollection collectionA = (WaypointCollection)a;
                if (b instanceof WaypointCollection) {
                    WaypointCollection collectionB = (WaypointCollection)b;
                    return collectionA.getName().compareTo(collectionB.getName());
                }
            }
            return 0;
        });
    }
}

