/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.activity.widgets.IconPickerWidget;
import net.labymod.addons.waypoints.core.activity.widgets.WaypointWidget;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointBuilder;
import net.labymod.addons.waypoints.waypoint.WaypointIcon;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointObjectMeta;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.plain.PlainTextComponentSerializer;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.NumberTextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.util.Color;
import net.labymod.api.util.I18n;
import net.labymod.api.util.logging.Logging;
import net.labymod.api.util.math.position.Position;
import net.labymod.api.util.math.vector.DoubleVector3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Links(value={@Link(value="overview.lss"), @Link(value="manage-popup.lss")})
public class ManageWaypointSimplePopup
extends SimpleAdvancedPopup {
    private static final Logging LOGGER = Logging.create(ManageWaypointSimplePopup.class);
    private final Action action;
    private final SimpleAdvancedPopup.SimplePopupButton doneButton;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final WaypointMeta waypoint;
    private final WaypointWidget waypointWidget;
    private Consumer<Waypoint> saveListener;

    protected ManageWaypointSimplePopup(@NotNull Action action, @NotNull WaypointMeta waypoint, @Nullable WaypointObjectMeta worldObjectMeta) {
        this.action = action;
        this.title = switch (action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.text((String)"Create Waypoint");
            case 1 -> Component.text((String)"Edit Waypoint");
        };
        this.waypoint = waypoint;
        this.doneButton = SimpleAdvancedPopup.SimplePopupButton.create((Component)Component.translatable((String)"labymod.ui.button.save", (Component[])new Component[0]), button -> this.saveWaypoint());
        this.buttons = new ArrayList();
        this.buttons.add(SimpleAdvancedPopup.SimplePopupButton.cancel());
        this.buttons.add(this.doneButton);
        if (action == Action.EDIT) {
            this.buttons.add(SimpleAdvancedPopup.SimplePopupButton.create((String)"cancel", (Component)Component.translatable((String)"labyswaypoints.gui.manage.remove.button", (Component[])new Component[0]), button -> {
                WaypointService service = Waypoints.references().waypointService();
                Waypoint original = service.get(this.waypoint.getIdentifier());
                if (original != null) {
                    service.remove(original.meta());
                } else {
                    service.remove(this.waypoint);
                    LOGGER.warn((CharSequence)("The waypoint with the identifier '" + this.waypoint.getIdentifier() + "' could not be found. Using fallback, but this could cause the waypoint to reappear unexpectedly later."), new Object[0]);
                }
                service.refresh();
            }));
        }
        this.waypointWidget = worldObjectMeta == null ? null : new WaypointWidget(waypoint, worldObjectMeta);
    }

    public ManageWaypointSimplePopup() {
        this(Action.ADD, ManageWaypointSimplePopup.createDefaultBuilder().build(), null);
    }

    public ManageWaypointSimplePopup(@NotNull WaypointMeta waypoint) {
        this(Action.EDIT, waypoint.copy(), null);
    }

    public ManageWaypointSimplePopup(@NotNull Waypoint waypoint) {
        this(Action.EDIT, waypoint.meta().copy(), waypoint.waypointObjectMeta());
    }

    @NotNull
    private static WaypointBuilder createDefaultBuilder() {
        ClientPlayer player = Laby.labyAPI().minecraft().getClientPlayer();
        if (player == null) {
            throw new IllegalStateException("Player is null");
        }
        String name = I18n.getTranslation((String)"labyswaypoints.defaultName", (Object[])new Object[0]);
        if (name == null) {
            name = "New Waypoint";
        }
        Position position = player.position();
        return WaypointBuilder.create().title((Component)Component.text((String)name)).type(WaypointType.PERMANENT).location(new DoubleVector3(Math.floor(position.getX()) + 0.5, (double)((int)(position.getY() + (double)player.getEyeHeight())), Math.floor(position.getZ()) + 0.5)).applyCurrentContext().currentDimension();
    }

    protected void initializeCustomWidgets(VerticalListWidget<Widget> container) {
        this.conditions.clear();
        if (this.waypointWidget != null) {
            container.addChild((Widget)this.waypointWidget);
        }
        FlexibleContentWidget nameWrapper = new FlexibleContentWidget();
        nameWrapper.addId("horizontal-wrapper");
        nameWrapper.addContent(this.createLabeledWidget((Component)Component.text((String)"Icon"), () -> {
            IconPickerWidget iconPicker = new IconPickerWidget();
            iconPicker.addId("icon-picker");
            iconPicker.addAll(WaypointIcon.getDefaultIcons());
            iconPicker.setSelected(this.waypoint.icon());
            iconPicker.setChangeListener(icon -> {
                this.waypoint.setIcon((Icon)icon);
                if (this.waypointWidget != null) {
                    this.waypointWidget.updateIcon();
                }
            });
            return iconPicker;
        }));
        nameWrapper.addFlexibleContent(this.createLabeledWidget((Component)Component.text((String)"Name"), () -> {
            String text = PlainTextComponentSerializer.plainText().serialize(this.waypoint.title());
            Condition condition = new Condition(!text.isEmpty());
            this.conditions.add(condition);
            TextFieldWidget nameInput = new TextFieldWidget();
            nameInput.clearButton().set((Object)true);
            nameInput.setText(text);
            nameInput.placeholder((Component)Component.text((String)"Enter a name"));
            nameInput.updateListener(newValue -> {
                newValue = newValue.trim();
                this.waypoint.setTitle((Component)Component.text((String)newValue));
                if (this.waypointWidget != null) {
                    this.waypointWidget.updateTitle();
                }
                this.updateCondition(condition, !newValue.isEmpty());
            });
            return nameInput;
        })).addId("flexible");
        nameWrapper.addContent(this.createLabeledWidget((Component)Component.text((String)"Color"), () -> {
            ColorPickerWidget colorPickerWidget = ColorPickerWidget.of((Color)this.waypoint.color());
            colorPickerWidget.addUpdateListener((Object)this, color -> {
                this.waypoint.setColor((Color)color);
                if (this.waypointWidget != null) {
                    this.waypointWidget.updateColor();
                }
            });
            return colorPickerWidget;
        }));
        container.addChild((Widget)nameWrapper);
        FlexibleContentWidget positionWrapper = new FlexibleContentWidget();
        positionWrapper.addId("horizontal-wrapper");
        positionWrapper.addFlexibleContent(this.createPositionWidget("X", this.waypoint.location().getX(), value -> this.waypoint.location().setX(value)));
        positionWrapper.addFlexibleContent(this.createPositionWidget("Y", this.waypoint.location().getY(), value -> this.waypoint.location().setY(value)));
        positionWrapper.addFlexibleContent(this.createPositionWidget("Z", this.waypoint.location().getZ(), value -> this.waypoint.location().setZ(value)));
        container.addChild((Widget)positionWrapper);
        this.doneButton.enabled(this.allConditionsMet());
    }

    protected void initializeButtons(VerticalListWidget<Widget> container) {
        super.initializeButtons(container);
    }

    private Widget createPositionWidget(String label, double defaultValue, DoubleConsumer valueConsumer) {
        return this.createLabeledWidget((Component)Component.text((String)label), () -> {
            NumberTextFieldWidget textField = new NumberTextFieldWidget();
            textField.setValue((int)defaultValue);
            textField.onUpdate(newValue -> {
                double value = newValue;
                if (label.equals("X") || label.equals("Z")) {
                    value += 0.5;
                }
                valueConsumer.accept(value);
            });
            return textField;
        });
    }

    private Widget createLabeledWidget(Component label, Supplier<Widget> widgetSupplier) {
        FlexibleContentWidget labelContainer = new FlexibleContentWidget();
        labelContainer.addId("labeled-widget");
        labelContainer.addContent((Widget)ComponentWidget.component((Component)label));
        labelContainer.addContent(widgetSupplier.get());
        return labelContainer;
    }

    private void updateCondition(Condition condition, boolean fulfilled) {
        condition.fulfilled = fulfilled;
        this.doneButton.enabled(this.allConditionsMet());
    }

    private boolean allConditionsMet() {
        for (Condition condition : this.conditions) {
            if (condition.fulfilled) continue;
            return false;
        }
        return true;
    }

    private void saveWaypoint() {
        WaypointService waypointService = Waypoints.references().waypointService();
        Waypoint waypoint = this.action == Action.ADD ? waypointService.add(this.waypoint) : waypointService.update(this.waypoint);
        waypointService.refresh();
        if (this.saveListener != null) {
            this.saveListener.accept(waypoint);
        }
    }

    public ManageWaypointSimplePopup onSave(Consumer<Waypoint> waypoint) {
        this.saveListener = waypoint;
        return this;
    }

    public ManageWaypointSimplePopup onSave(Runnable runnable) {
        return this.onSave((Waypoint saved) -> runnable.run());
    }

    public static enum Action {
        ADD,
        EDIT;

    }

    private static class Condition {
        boolean fulfilled;

        Condition(boolean defaultFulfilled) {
            this.fulfilled = defaultFulfilled;
        }
    }
}

