/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.labymod.addons.waypoints.waypoint.WaypointIcon;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.util.gson.LabyGsonTypeAdapter;

public class IconTypeAdapter
extends LabyGsonTypeAdapter<Icon> {
    public Icon deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object;
        if (json.isJsonObject() && (object = json.getAsJsonObject()).has("path")) {
            String path = object.get("path").getAsString();
            return WaypointIcon.getByPath(path);
        }
        throw new JsonParseException("Invalid waypoint icon json: " + String.valueOf(json));
    }

    public JsonElement serialize(Icon icon, Type typeOfSrc, JsonSerializationContext context) {
        ResourceLocation resourceLocation = icon.getResourceLocation();
        if (resourceLocation == null) {
            throw new JsonParseException("Cannot serialize waypoint icon without resource location: " + String.valueOf(icon));
        }
        JsonObject object = new JsonObject();
        object.addProperty("path", resourceLocation.getPath());
        return object;
    }
}

