/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.waypoint;

import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.WaypointsAddon;
import net.labymod.addons.waypoints.core.WaypointsConfiguration;
import net.labymod.addons.waypoints.core.WaypointsRenderPrograms;
import net.labymod.addons.waypoints.core.waypoint.WaypointIndicatorWidget;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointObjectMeta;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gfx.shader.ShaderTextures;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.util.WidgetMeta;
import net.labymod.api.client.render.batch.RectangleRenderContext;
import net.labymod.api.client.render.batch.ResourceRenderContext;
import net.labymod.api.client.render.draw.batch.BatchResourceRenderer;
import net.labymod.api.client.render.font.ComponentRenderer;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.world.MinecraftCamera;
import net.labymod.api.client.world.object.AbstractWorldObject;
import net.labymod.api.util.math.vector.DoubleVector3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultWaypoint
extends AbstractWorldObject
implements Waypoint {
    private static final float BACKGROUND_DEPTH = 0.01f;
    private static final float WAYPOINT_SCALE = 0.04f;
    private static final float BEACON_BEAM_SIZE = 0.3f;
    private static final float BEACON_BEAM_START_Y = -1024.0f;
    private static final float BEACON_BEAM_END_Y = 2048.0f;
    private static final float BEACON_BEAM_SPRITE_WIDTH = 256.0f;
    private static final float BEACON_BEAM_SPRITE_HEIGHT = 2621440.0f;
    private static final float ICON_SIZE = 8.0f;
    private static final float GAP = 3.0f;
    private static final ResourceLocation BEACON_BEAM = Waypoints.ofPath("textures/beacon_beam.png");
    private static final RectangleRenderContext RECTANGLE_RENDER_CONTEXT = Laby.references().rectangleRenderContext();
    private static final ResourceRenderContext RESOURCE_RENDER_CONTEXT = Laby.references().resourceRenderContext();
    private static final ComponentRenderer COMPONENT_RENDERER = Laby.references().componentRenderer();
    private final WidgetMeta widgetMeta = new WidgetMeta();
    private final WaypointObjectMeta waypointObjectMeta;
    private final WaypointMeta meta;
    private final WaypointsAddon addon;
    private final DoubleVector3 prevPosition = new DoubleVector3();
    private float rectX;
    private float rectY;
    private boolean hasPrevPosition;

    public DefaultWaypoint(WaypointsAddon addon, WaypointMeta meta, WaypointObjectMeta waypointObjectMeta) {
        super(waypointObjectMeta.pos().copy());
        this.addon = addon;
        this.waypointObjectMeta = waypointObjectMeta;
        this.meta = meta;
    }

    @Override
    public WaypointMeta meta() {
        return this.meta;
    }

    @NotNull
    public DoubleVector3 previousPosition() {
        return this.prevPosition;
    }

    public boolean hasPrevPosition() {
        return this.hasPrevPosition;
    }

    public void applyPreviousPosition() {
        this.prevPosition.set(this.position());
        this.hasPrevPosition = true;
    }

    public void setHasPrevPosition(boolean hasPrevPosition) {
        this.hasPrevPosition = hasPrevPosition;
    }

    @Override
    public WaypointObjectMeta waypointObjectMeta() {
        return this.waypointObjectMeta;
    }

    public boolean shouldRender() {
        return this.isEnabled() && !this.waypointObjectMeta.isOutOfRange();
    }

    public boolean shouldRenderInOverlay() {
        return this.isEnabled() && (Boolean)((WaypointsConfiguration)this.addon.configuration()).showHudIndicators().get() != false;
    }

    @Nullable
    public Widget createWidget() {
        return new WaypointIndicatorWidget(this);
    }

    public void renderInWorld(@NotNull MinecraftCamera cam, @NotNull Stack stack, double x, double y, double z, float delta, boolean darker) {
        stack.push();
        this.renderBeaconBeam(cam, stack, x, y, z, delta);
        stack.pop();
        stack.push();
        float alpha = this.waypointObjectMeta.getAlpha();
        if (alpha != 1.0f) {
            this.widgetMeta.multiplyAlpha(alpha);
        }
        stack.scale(0.04f * this.waypointObjectMeta.getScale());
        this.rotateHorizontally(cam, stack);
        this.rotateVertically(cam, stack);
        stack.push();
        stack.translate(0.0f, 0.0f, 0.01f);
        this.renderBackground(stack, 1.0f);
        stack.pop();
        this.renderIcon(stack);
        this.renderText(stack);
        if (alpha != 1.0f) {
            this.widgetMeta.revertAlphaState();
        }
        stack.pop();
    }

    private void renderBeaconBeam(@NotNull MinecraftCamera cam, @NotNull Stack stack, double x, double y, double z, float delta) {
        if (!((Boolean)((WaypointsConfiguration)this.addon.configuration()).beaconBeam().get()).booleanValue()) {
            return;
        }
        float dynamicBeaconBeamSize = (float)((double)0.3f * (1.0 + (x + z) / 180.0));
        float rotation = (float)(System.currentTimeMillis() % 3600L) / 20.0f;
        float upwards = (float)(System.currentTimeMillis() % 2000L) / 1000.0f * dynamicBeaconBeamSize;
        int color = this.meta.color().get();
        stack.rotate(rotation, 0.0f, 1.0f, 0.0f);
        stack.translate(-dynamicBeaconBeamSize / 2.0f, -upwards, -dynamicBeaconBeamSize / 2.0f);
        BatchResourceRenderer renderer = Laby.labyAPI().renderPipeline().resourceRenderer().beginBatch(stack, BEACON_BEAM);
        for (int i = 0; i < 4; ++i) {
            stack.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            stack.translate(-dynamicBeaconBeamSize, 0.0f, 0.0f);
            ((BatchResourceRenderer)((BatchResourceRenderer)((BatchResourceRenderer)((BatchResourceRenderer)renderer.pos(0.0f, -1024.0f)).size(dynamicBeaconBeamSize, 2048.0f)).color(color)).sprite(0.0f, 0.0f, 256.0f, 2621440.0f)).build();
        }
        renderer.upload(WaypointsRenderPrograms.BEACON_BEAM);
    }

    public void renderBackground(Stack stack, float padding) {
        Component text = this.waypointObjectMeta().formatTitle(this.getType());
        float iconWidth = (Boolean)((WaypointsConfiguration)this.addon.configuration()).icon().get() != false ? 11.0f : 0.0f;
        this.rectX = (COMPONENT_RENDERER.width(text) + iconWidth - 1.0f) / 2.0f;
        this.rectY = COMPONENT_RENDERER.height() / 2.0f;
        if (!((Boolean)((WaypointsConfiguration)this.addon.configuration()).background().get()).booleanValue()) {
            return;
        }
        RECTANGLE_RENDER_CONTEXT.begin(stack);
        RECTANGLE_RENDER_CONTEXT.render(-this.rectX - padding, -this.rectY - padding, this.rectX + padding, this.rectY + padding - 1.0f, 0x4C000000);
        RECTANGLE_RENDER_CONTEXT.uploadToBuffer(WaypointsRenderPrograms.BACKGROUND);
    }

    public void renderIcon(Stack stack) {
        if (!((Boolean)((WaypointsConfiguration)this.addon.configuration()).icon().get()).booleanValue()) {
            return;
        }
        ResourceLocation resourceLocation = this.meta().icon().getResourceLocation();
        if (resourceLocation != null) {
            RESOURCE_RENDER_CONTEXT.begin(stack);
            ShaderTextures.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
            Icon icon = this.meta.icon();
            icon.render(RESOURCE_RENDER_CONTEXT, -this.rectX, -this.rectY, 8.0f, 8.0f, false, this.meta.iconColor());
            RESOURCE_RENDER_CONTEXT.uploadToBuffer(WaypointsRenderPrograms.ICON);
        }
    }

    private WaypointObjectMeta.Type getType() {
        return (Boolean)((WaypointsConfiguration)this.addon.configuration()).beaconBeam().get() != false ? WaypointObjectMeta.Type.WITHOUT_COLOR : WaypointObjectMeta.Type.WITH_COLOR;
    }

    public void renderText(Stack stack) {
        Component text = this.waypointObjectMeta().formatTitle(this.getType());
        float iconWidth = (Boolean)((WaypointsConfiguration)this.addon.configuration()).icon().get() != false ? 11.0f : 0.0f;
        COMPONENT_RENDERER.builder().text(text).shadow(false).pos(-this.rectX + iconWidth, -this.rectY).useFloatingPointPosition(true).allowColors(true).render(stack);
        COMPONENT_RENDERER.builder().text(text).shadow(false).discrete(true).pos(-this.rectX + iconWidth, -this.rectY).useFloatingPointPosition(true).allowColors(true).render(stack);
    }

    private boolean isEnabled() {
        return (Boolean)((WaypointsConfiguration)this.addon.configuration()).enabled().get();
    }
}

