/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.waypoint;

import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.waypoint.WaypointBuilder;
import net.labymod.addons.waypoints.waypoint.WaypointContext;
import net.labymod.addons.waypoints.waypoint.WaypointIcon;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.network.server.ServerAddress;
import net.labymod.api.models.Implements;
import net.labymod.api.util.Color;
import net.labymod.api.util.debug.Preconditions;
import net.labymod.api.util.math.vector.DoubleVector3;
import org.jetbrains.annotations.NotNull;

@Implements(value=WaypointBuilder.class)
public class DefaultWaypointBuilder
implements WaypointBuilder {
    private String identifier;
    private Component title;
    private Color color = Color.WHITE;
    private Icon icon = WaypointIcon.DEFAULT;
    private WaypointType type;
    private DoubleVector3 location;
    private boolean visible = true;
    private String dimension;
    private WaypointContext contextType;
    private String context;

    @Override
    @NotNull
    public WaypointBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder title(Component title) {
        this.title = title;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder color(Color color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder icon(Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder type(WaypointType type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder location(DoubleVector3 location) {
        this.location = location;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder singlePlayer(String world) {
        this.contextType = world == null ? null : WaypointContext.SINGLE_PLAYER;
        this.context = world;
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder server(ServerAddress server) {
        this.contextType = server == null ? null : WaypointContext.MULTI_PLAYER;
        this.context = server == null ? null : server.toString();
        return this;
    }

    @Override
    @NotNull
    public WaypointBuilder dimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @Override
    @NotNull
    public WaypointMeta build() {
        WaypointService waypointService = Waypoints.references().waypointService();
        if (this.identifier == null) {
            this.identifier = waypointService.generateUniqueIdentifier();
        }
        Preconditions.notNull((Object)this.title, (String)"Missing title");
        Preconditions.notNull((Object)this.color, (String)"Missing color");
        Preconditions.notNull((Object)((Object)this.type), (String)"Missing type");
        Preconditions.notNull((Object)this.location, (String)"Missing location");
        Preconditions.notNull((Object)this.icon, (String)"Missing icon");
        Preconditions.notNull((Object)this.dimension, (String)"Missing dimension");
        if (this.context == null || this.contextType == null) {
            throw new NullPointerException("Missing server or world");
        }
        return new WaypointMeta(this.identifier, this.title, this.color, this.type, this.location, this.contextType, this.context, this.icon, this.dimension, this.visible);
    }
}

