/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.waypoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WaypointIcon {
    public static final List<Icon> ICONS = new ArrayList<Icon>();
    @NotNull
    public static final Icon DEFAULT = WaypointIcon.register("marker");

    public static Icon register(@NotNull String path) {
        ResourceLocation resourceLocation = Waypoints.ofPath("textures/icons/" + path + ".png");
        Icon icon = Icon.texture((ResourceLocation)resourceLocation);
        ICONS.add(icon);
        return icon;
    }

    public static Collection<Icon> getDefaultIcons() {
        return ICONS;
    }

    public static Icon getByPath(String path) {
        for (Icon icon : ICONS) {
            if (icon.getResourceLocation() == null || !icon.getResourceLocation().getPath().equals(path)) continue;
            return icon;
        }
        return DEFAULT;
    }

    static {
        WaypointIcon.register("home");
        WaypointIcon.register("pickaxe");
        WaypointIcon.register("lettuce");
        WaypointIcon.register("wheat");
        WaypointIcon.register("tree");
        WaypointIcon.register("bucket");
        WaypointIcon.register("skull");
        WaypointIcon.register("bank");
        WaypointIcon.register("cave");
        WaypointIcon.register("castle");
        WaypointIcon.register("chest");
        WaypointIcon.register("bee");
        WaypointIcon.register("sheep");
        WaypointIcon.register("pig");
        WaypointIcon.register("chicken");
        WaypointIcon.register("enderchest");
        WaypointIcon.register("coal");
        WaypointIcon.register("lapis");
        WaypointIcon.register("redstone");
        WaypointIcon.register("gold");
        WaypointIcon.register("iron");
        WaypointIcon.register("golem");
        WaypointIcon.register("dark_mushroom");
        WaypointIcon.register("bright_mushroom");
        WaypointIcon.register("sugarcane");
        WaypointIcon.register("fishing");
        WaypointIcon.register("dungeon");
        WaypointIcon.register("netherite");
        WaypointIcon.register("furnace");
        WaypointIcon.register("steak");
        WaypointIcon.register("hoe");
        WaypointIcon.register("rose");
        WaypointIcon.register("grass");
        WaypointIcon.register("torch");
        WaypointIcon.register("campfire");
        WaypointIcon.register("beam");
        WaypointIcon.register("leather");
        WaypointIcon.register("crap");
        WaypointIcon.register("anvil");
        WaypointIcon.register("emerald");
        WaypointIcon.register("pearl");
        WaypointIcon.register("eye");
        WaypointIcon.register("portal");
        WaypointIcon.register("stone");
    }
}

