/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core;

import javax.inject.Singleton;
import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.api.generated.ReferenceStorage;
import net.labymod.addons.waypoints.core.WaypointsConfiguration;
import net.labymod.addons.waypoints.core.listener.ConfigurationVersionUpdateListener;
import net.labymod.addons.waypoints.core.listener.JsonConfigLoaderInitializeListener;
import net.labymod.addons.waypoints.core.listener.ServerWaypointListener;
import net.labymod.addons.waypoints.core.listener.WaypointHotkeyListener;
import net.labymod.addons.waypoints.core.listener.WaypointUpdateListener;
import net.labymod.addons.waypoints.core.serverapi.handler.WaypointDimensionPacketHandler;
import net.labymod.addons.waypoints.core.serverapi.handler.WaypointPacketHandler;
import net.labymod.addons.waypoints.core.serverapi.handler.WaypointRemovePacketHandler;
import net.labymod.addons.waypoints.core.waypoint.DefaultWaypointService;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.serverapi.LabyModProtocolService;
import net.labymod.serverapi.api.packet.PacketHandler;
import net.labymod.serverapi.core.AddonProtocol;
import net.labymod.serverapi.integration.waypoints.WaypointsIntegration;
import net.labymod.serverapi.integration.waypoints.packets.WaypointDimensionPacket;
import net.labymod.serverapi.integration.waypoints.packets.WaypointPacket;
import net.labymod.serverapi.integration.waypoints.packets.WaypointRemovePacket;

@AddonMain
@Singleton
@Referenceable
public class WaypointsAddon
extends LabyAddon<WaypointsConfiguration> {
    protected void preConfigurationLoad() {
        this.registerListener(new ConfigurationVersionUpdateListener());
        this.registerListener(new JsonConfigLoaderInitializeListener());
    }

    protected void load() {
        Waypoints.init((ReferenceStorage)this.referenceStorageAccessor());
    }

    protected void enable() {
        this.registerSettingCategory();
        WaypointService waypointService = Waypoints.references().waypointService();
        ((DefaultWaypointService)waypointService).load(this);
        waypointService.setCurrentDimension();
        WaypointDimensionPacketHandler dimensionPacketHandler = new WaypointDimensionPacketHandler();
        this.registerListener(new WaypointHotkeyListener(this));
        this.registerListener(new ServerWaypointListener(dimensionPacketHandler));
        this.registerListener(new WaypointUpdateListener(this));
        LabyModProtocolService protocolService = Laby.references().labyModProtocolService();
        WaypointsIntegration integration = (WaypointsIntegration)protocolService.getOrRegisterIntegration(WaypointsIntegration.class, WaypointsIntegration::new);
        AddonProtocol protocol = integration.waypointsProtocol();
        protocol.registerHandler(WaypointPacket.class, (PacketHandler)new WaypointPacketHandler());
        protocol.registerHandler(WaypointRemovePacket.class, (PacketHandler)new WaypointRemovePacketHandler());
        protocol.registerHandler(WaypointDimensionPacket.class, (PacketHandler)dimensionPacketHandler);
    }

    protected Class<WaypointsConfiguration> configurationClass() {
        return WaypointsConfiguration.class;
    }
}

