/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.activity.WaypointsActivity;
import net.labymod.addons.waypoints.event.WaypointAddEvent;
import net.labymod.addons.waypoints.event.WaypointRemoveEvent;
import net.labymod.addons.waypoints.utils.DistanceFormatting;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.Laby;
import net.labymod.api.addon.AddonConfig;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.settings.ActivitySettingWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.KeybindWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.configuration.loader.annotation.Exclude;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingListener;
import net.labymod.api.configuration.settings.annotation.SettingRequires;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.configuration.settings.type.SettingElement;
import net.labymod.api.event.DefaultCancellable;
import net.labymod.api.event.Event;
import net.labymod.api.util.Color;
import net.labymod.api.util.MethodOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class WaypointsConfiguration
extends AddonConfig {
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> enabled = (ConfigProperty)new ConfigProperty((Object)true).addChangeListener(value -> Waypoints.refresh());
    @SettingSection(value="Waypoints")
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private final ConfigProperty<Key> permanentHotkey = new ConfigProperty((Object)Key.M);
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private final ConfigProperty<Key> editClosestKey = new ConfigProperty((Object)Key.NONE);
    @SettingSection(value="Settings")
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> background = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> icon = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> beaconBeam = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> showHudIndicators = new ConfigProperty((Object)false);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> alwaysShowWaypoints = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    @SettingRequires(value="alwaysShowWaypoints")
    private final ConfigProperty<Boolean> hideWhenOutOfRange = new ConfigProperty((Object)true);
    @SliderWidget.SliderSetting(min=128.0f, max=8192.0f, steps=128.0f)
    @SettingRequires(value="hideWhenOutOfRange")
    private final ConfigProperty<Integer> outOfRangeDistance = new ConfigProperty((Object)2048);
    @SwitchWidget.SwitchSetting
    @SettingRequires(value="hideWhenOutOfRange")
    private final ConfigProperty<Boolean> fadeOut = new ConfigProperty((Object)true);
    @SettingSection(value="distance")
    @DropdownWidget.DropdownSetting
    private final ConfigProperty<DistanceFormatting> distanceFormatting = ConfigProperty.createEnum((Enum)DistanceFormatting.BRACKETS);
    @ColorPickerWidget.ColorPickerSetting
    private final ConfigProperty<Color> distanceBracketColor = new ConfigProperty((Object)Color.GRAY);
    @ColorPickerWidget.ColorPickerSetting
    private final ConfigProperty<Color> distanceValueColor = new ConfigProperty((Object)Color.WHITE);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> distanceBeforeName = new ConfigProperty((Object)false);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> hideDistance = new ConfigProperty((Object)false);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> convertToKilometers = new ConfigProperty((Object)false);
    @SliderWidget.SliderSetting(min=100.0f, max=2000.0f, steps=100.0f)
    @SettingRequires(value="convertToKilometers")
    private final ConfigProperty<Integer> kilometersThreshold = new ConfigProperty((Object)1000);
    @Exclude
    private final List<WaypointMeta> waypoints = new ArrayList<WaypointMeta>();
    private final transient List<WaypointMeta> unmodifiableWaypoints = Collections.unmodifiableList(this.waypoints);

    public ConfigProperty<Boolean> enabled() {
        return this.enabled;
    }

    public ConfigProperty<Key> createKey() {
        return this.permanentHotkey;
    }

    public ConfigProperty<Key> editClosestKey() {
        return this.editClosestKey;
    }

    public ConfigProperty<Boolean> background() {
        return this.background;
    }

    public ConfigProperty<Boolean> icon() {
        return this.icon;
    }

    public ConfigProperty<Boolean> beaconBeam() {
        return this.beaconBeam;
    }

    public ConfigProperty<Boolean> scaleDynamically() {
        return this.alwaysShowWaypoints;
    }

    public ConfigProperty<Boolean> showHudIndicators() {
        return this.showHudIndicators;
    }

    public ConfigProperty<Color> distanceValueColor() {
        return this.distanceValueColor;
    }

    public ConfigProperty<Color> distanceBracketColor() {
        return this.distanceBracketColor;
    }

    public ConfigProperty<DistanceFormatting> distanceFormatting() {
        return this.distanceFormatting;
    }

    public ConfigProperty<Boolean> distanceBeforeName() {
        return this.distanceBeforeName;
    }

    public ConfigProperty<Boolean> hideDistance() {
        return this.hideDistance;
    }

    public ConfigProperty<Boolean> hideWhenOutOfRange() {
        return this.hideWhenOutOfRange;
    }

    public ConfigProperty<Integer> outOfRangeDistance() {
        return this.outOfRangeDistance;
    }

    public ConfigProperty<Boolean> fadeOut() {
        return this.fadeOut;
    }

    public ConfigProperty<Boolean> convertToKilometers() {
        return this.convertToKilometers;
    }

    public ConfigProperty<Integer> kilometersThreshold() {
        return this.kilometersThreshold;
    }

    @ActivitySettingWidget.ActivitySetting
    @MethodOrder(after="editClosestKey")
    public Activity openWaypoints() {
        return new WaypointsActivity();
    }

    @SettingListener(target="kilometersThreshold", type=SettingListener.EventType.INITIALIZE)
    public void initializeKilometersThreshold(SettingElement setting) {
        Widget widget = setting.getWidgets()[0];
        if (!(widget instanceof SliderWidget)) {
            return;
        }
        SliderWidget sliderWidget = (SliderWidget)widget;
        sliderWidget.withFormatter(value -> Component.text((String)((int)value + "m")));
    }

    public @Unmodifiable List<WaypointMeta> getWaypoints() {
        return this.waypoints;
    }

    public boolean addWaypoint(WaypointMeta meta) {
        if (this.hasWaypoint(meta)) {
            throw new IllegalArgumentException("A waypoint with this identifier is already registered.");
        }
        DefaultCancellable event = (DefaultCancellable)Laby.fireEvent((Event)new WaypointAddEvent(meta));
        if (event.isCancelled()) {
            return false;
        }
        if (meta.type() == WaypointType.PERMANENT) {
            this.waypoints.add(meta);
        }
        return true;
    }

    public boolean removeWaypoint(@NotNull WaypointMeta meta) {
        if (!this.hasWaypoint(meta)) {
            throw new IllegalArgumentException("No waypoint with this identifier is registered.");
        }
        DefaultCancellable event = (DefaultCancellable)Laby.fireEvent((Event)new WaypointRemoveEvent(meta));
        if (event.isCancelled()) {
            return false;
        }
        this.waypoints.remove(meta);
        return true;
    }

    public boolean update(@NotNull WaypointMeta meta) {
        int index = -1;
        for (int i = 0; i < this.waypoints.size(); ++i) {
            if (!this.waypoints.get(i).equals(meta)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        this.waypoints.set(index, meta);
        return true;
    }

    public boolean hasWaypoint(WaypointMeta meta) {
        return this.waypoints.contains(meta);
    }

    public int getConfigVersion() {
        return 2;
    }
}

