/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.widgets;

import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointObjectMeta;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@AutoWidget
public class WaypointWidget
extends FlexibleContentWidget {
    protected final WaypointMeta meta;
    protected final WaypointObjectMeta worldObjectMeta;
    private IconWidget iconWidget;
    private ComponentWidget titleWidget;
    private ComponentWidget distanceWidget;
    private double lastDistance = Double.MIN_VALUE;

    public WaypointWidget(WaypointMeta meta, WaypointObjectMeta worldObjectMeta) {
        this.meta = meta;
        this.worldObjectMeta = worldObjectMeta;
        this.addId("waypoint-widget");
    }

    public WaypointWidget(WaypointMeta meta) {
        this(meta, null);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        Icon icon = this.meta.icon();
        this.iconWidget = new IconWidget(icon);
        this.iconWidget.color().set((Object)this.meta.iconColor());
        this.iconWidget.addId(new String[]{"icon", "waypoint-icon"});
        this.addContent((Widget)this.iconWidget);
        this.titleWidget = ComponentWidget.component((Component)this.meta.title());
        this.titleWidget.addId("title");
        this.titleWidget.textColor().set((Object)this.meta.color().get());
        this.addFlexibleContent((Widget)this.titleWidget);
        if (this.meta.type() == WaypointType.SERVER_SESSION) {
            IconWidget typeWidget = new IconWidget(Textures.SpriteCommon.EXCLAMATION_MARK_LIGHT);
            typeWidget.addId("type");
            typeWidget.setHoverComponent((Component)Component.translatable((String)"labyswaypoints.gui.overview.temporary", (Component[])new Component[0]));
            this.addContent((Widget)typeWidget);
        }
        if (this.worldObjectMeta == null) {
            this.distanceWidget = null;
        } else {
            this.lastDistance = this.worldObjectMeta.getDistance();
            this.distanceWidget = ComponentWidget.component((Component)this.worldObjectMeta.createDistanceComponent());
            this.addContent((Widget)this.distanceWidget);
        }
    }

    public void tick() {
        super.tick();
        this.updateDistance();
    }

    public void updateTitle() {
        if (this.titleWidget == null) {
            return;
        }
        this.titleWidget.setComponent(this.meta.title());
    }

    public void updateColor() {
        if (this.iconWidget != null) {
            this.iconWidget.color().set((Object)this.meta.iconColor());
        }
        if (this.titleWidget != null) {
            this.titleWidget.textColor().set((Object)this.meta.color().get());
        }
    }

    public void updateDistance() {
        if (this.distanceWidget == null || this.worldObjectMeta == null) {
            return;
        }
        double distance = this.worldObjectMeta.getDistance();
        if (this.lastDistance == distance) {
            return;
        }
        this.lastDistance = distance;
        this.distanceWidget.setComponent(this.worldObjectMeta.createDistanceComponent());
    }

    public void updateIcon() {
        if (this.iconWidget == null) {
            return;
        }
        this.iconWidget.icon().set((Object)this.meta.icon());
        this.updateColor();
    }
}

