/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.labymod.addons.waypoints.WaypointConfigurationStorage;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.api.Laby;
import net.labymod.api.client.network.server.ServerAddress;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Referenceable
public interface WaypointService {
    @Deprecated
    public static final String SINGLELAYER_SERVER = "SINGLEPLAYER";

    public WaypointConfigurationStorage configurationStorage();

    public void refresh();

    @Nullable
    public Waypoint add(@NotNull WaypointMeta var1);

    public boolean remove(@NotNull WaypointMeta var1);

    @Nullable
    public Waypoint update(@NotNull WaypointMeta var1);

    public boolean remove(@NotNull Predicate<Waypoint> var1);

    @Nullable
    public Waypoint get(@NotNull String var1);

    @Nullable
    default public Waypoint get(@NotNull WaypointMeta meta) {
        return this.get(meta.getIdentifier());
    }

    public @Unmodifiable @NotNull List<Waypoint> getAll();

    public @Unmodifiable @NotNull Set<Waypoint> getVisible();

    public boolean isWaypointsRenderCache();

    public void setWaypointsRenderCache(boolean var1);

    @Nullable
    public String getSinglePlayerWorld();

    @Nullable
    public ServerAddress getServerAddress();

    @Nullable
    public String getDimension();

    public void setDimension(@NotNull String var1);

    default public void setDimension(@NotNull ResourceLocation dimension) {
        this.setDimension(dimension.toString());
    }

    public boolean isIdentifierAvailable(@NotNull String var1);

    public String generateUniqueIdentifier(@Nullable String var1);

    default public String generateUniqueIdentifier() {
        return this.generateUniqueIdentifier(null);
    }

    default public void setCurrentDimension() {
        this.setDimension(Laby.labyAPI().minecraft().clientWorld().dimension());
    }

    @Deprecated
    default public void setActualDimension(String dimension) {
        this.setDimension(dimension);
    }

    @Deprecated
    default public String actualDimension() {
        return this.getDimension();
    }

    @Deprecated
    default public void refreshWaypoints() {
        this.refresh();
    }

    @Deprecated
    default public void addWaypoint(WaypointMeta meta) {
        this.add(meta);
    }

    @Deprecated
    default public boolean removeWaypoint(WaypointMeta meta) {
        return this.remove(meta);
    }

    @Deprecated
    default public void removeWaypoints(Predicate<Waypoint> predicate) {
        this.remove(predicate);
    }

    @Deprecated
    default public Waypoint getWaypoint(WaypointMeta meta) {
        return this.get(meta);
    }

    @Deprecated
    default public Collection<Waypoint> getAllWaypoints() {
        return this.getAll();
    }

    @Deprecated
    default public Collection<Waypoint> getVisibleWaypoints() {
        return this.getVisible();
    }

    @Deprecated
    @Nullable
    default public String getWorld() {
        return this.getSinglePlayerWorld();
    }

    @Deprecated
    @NotNull
    default public String getServer() {
        if (this.getServerAddress() == null) {
            return SINGLELAYER_SERVER;
        }
        return this.getServerAddress().toString();
    }
}

