/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.activity.layout.WaypointCollection;
import net.labymod.addons.waypoints.core.activity.layout.WaypointContextCollection;
import net.labymod.addons.waypoints.core.activity.popup.ManageWaypointSimplePopup;
import net.labymod.addons.waypoints.core.activity.widgets.HeaderWidget;
import net.labymod.addons.waypoints.core.activity.widgets.WaypointListItemWidget;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointContext;
import net.labymod.addons.waypoints.waypoint.WaypointMeta;
import net.labymod.addons.waypoints.waypoint.WaypointObjectMeta;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.HrWidget;
import net.labymod.api.client.network.server.ServerAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoActivity
@Links(value={@Link(value="manage.lss"), @Link(value="overview.lss")})
public class WaypointsActivity
extends Activity {
    private final WaypointService waypointService;
    private final VerticalListWidget<WaypointListItemWidget> waypointList;
    private final HeaderWidget headerWidget;
    private final List<WaypointContextCollection> waypointContexts = new ArrayList<WaypointContextCollection>();
    private WaypointContextCollection activeContext;
    private ArrayList<WaypointListItemWidget> waypointWidgets;
    private WaypointListItemWidget selectedWaypoint;
    private ButtonWidget removeButton;
    private ButtonWidget editButton;
    private WaypointCollection selectedCollection;

    public WaypointsActivity() {
        this.waypointService = Waypoints.references().waypointService();
        this.waypointList = new VerticalListWidget();
        this.waypointWidgets = new ArrayList();
        this.waypointList.addId("waypoints-list");
        this.headerWidget = new HeaderWidget(this);
        this.waypointList.setSelectCallback(waypointListItemWidget -> {
            WaypointListItemWidget selectedWidget = (WaypointListItemWidget)((Object)((Object)this.waypointList.listSession().getSelectedEntry()));
            if (selectedWidget == null || selectedWidget.getWaypointMeta() != waypointListItemWidget.getWaypointMeta()) {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        });
        this.waypointList.setDoubleClickCallback(waypointListItemWidget -> this.setAction(Action.EDIT));
        this.updateWaypointContextList();
    }

    private void updateWaypointContextList() {
        this.waypointContexts.clear();
        for (Waypoint waypoint : this.waypointService.getAll()) {
            WaypointContextCollection collection = this.getOrCreateByContext(waypoint);
            collection.add(waypoint);
        }
        this.waypointContexts.sort(Comparator.comparing(WaypointCollection::getName));
        this.activeContext = this.evaluateActiveContext();
    }

    @Nullable
    private WaypointContextCollection evaluateActiveContext() {
        ServerAddress serverAddress = this.waypointService.getServerAddress();
        String singlePlayerWorld = this.waypointService.getSinglePlayerWorld();
        if (serverAddress == null && singlePlayerWorld == null) {
            return null;
        }
        WaypointContextCollection activeContext = null;
        WaypointContext targetContext = serverAddress != null ? WaypointContext.MULTI_PLAYER : WaypointContext.SINGLE_PLAYER;
        String targetContextValue = serverAddress != null ? serverAddress.toString() : singlePlayerWorld;
        for (WaypointContextCollection waypointContext : this.waypointContexts) {
            if (waypointContext.context() != targetContext || !waypointContext.getContextValue().equals(targetContextValue)) continue;
            activeContext = waypointContext;
            break;
        }
        return activeContext;
    }

    @NotNull
    private WaypointContextCollection getOrCreateByContext(Waypoint waypoint) {
        WaypointMeta meta = waypoint.meta();
        for (WaypointContextCollection waypointContext : this.waypointContexts) {
            if (!meta.matchesContext(waypointContext.context(), waypointContext.getContextValue())) continue;
            return waypointContext;
        }
        WaypointContextCollection collection = new WaypointContextCollection(meta.contextType(), meta.getContext());
        this.waypointContexts.add(collection);
        return collection;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = new FlexibleContentWidget();
        container.addId("waypoints-container");
        ArrayList<WaypointListItemWidget> listItemWidgets = new ArrayList<WaypointListItemWidget>();
        this.waypointWidgets = listItemWidgets;
        container.addContent((Widget)this.headerWidget);
        VerticalListWidget widgets = new VerticalListWidget();
        widgets.addId("waypoints-overview-list");
        if (this.selectedCollection != null || this.activeContext != null) {
            WaypointCollection collection = this.selectedCollection != null ? this.selectedCollection : this.activeContext;
            HorizontalListWidget header = new HorizontalListWidget();
            header.addId("waypoints-list-header");
            if (this.selectedCollection != null) {
                ButtonWidget backButton = ButtonWidget.icon((Icon)Textures.SpriteCommon.BACK_BUTTON);
                backButton.addId("back-button");
                backButton.setPressListener(() -> {
                    this.selectedCollection = this.selectedCollection.getParent();
                    this.reload();
                    return true;
                });
                header.addEntry((Widget)backButton);
            }
            header.addEntry((Widget)ComponentWidget.text((String)("Waypoints on " + collection.getName())));
            widgets.addChild((Widget)header);
            for (Object e : collection.getEntries()) {
                if (!(e instanceof Waypoint)) continue;
                Waypoint waypoint = (Waypoint)e;
                WaypointObjectMeta objectMeta = this.waypointService.getVisible().contains(waypoint) ? waypoint.waypointObjectMeta() : null;
                WaypointListItemWidget listItemWidget = new WaypointListItemWidget(waypoint.meta(), objectMeta);
                listItemWidget.setPressable(() -> this.waypointList.listSession().setSelectedEntry((Object)listItemWidget));
                widgets.addChild((Widget)listItemWidget);
                listItemWidgets.add(listItemWidget);
                listItemWidget.getCheckbox().setPressable(() -> {
                    this.handleWaypointWidgetStyle(listItemWidget, !listItemWidget.getWaypointMeta().isVisible());
                    this.headerWidget.getCheckbox().setState(this.hasVisibleWaypoint() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
                });
            }
            if (this.selectedCollection == null && this.waypointContexts.size() > 1) {
                widgets.addChild((Widget)new HrWidget());
                ComponentWidget component = ComponentWidget.text((String)"Other Waypoints");
                component.addId("other-waypoints-header");
                widgets.addChild((Widget)component);
            }
        }
        if (this.selectedCollection == null) {
            for (WaypointContextCollection waypointContext : this.waypointContexts) {
                if (this.activeContext != null && waypointContext == this.activeContext) continue;
                ButtonWidget contextButton = ButtonWidget.text((String)waypointContext.getName(), (Icon)waypointContext.icon());
                contextButton.setPressListener(() -> {
                    this.selectedCollection = waypointContext;
                    this.reload();
                    return true;
                });
                widgets.addChild((Widget)contextButton);
            }
        }
        container.addFlexibleContent((Widget)new ScrollWidget(widgets));
        this.selectedWaypoint = (WaypointListItemWidget)((Object)this.waypointList.listSession().getSelectedEntry());
        HorizontalListWidget menu = new HorizontalListWidget();
        menu.addId("overview-button-menu");
        ButtonWidget addButton = ButtonWidget.i18n((String)"labymod.ui.button.add", () -> this.setAction(Action.ADD));
        addButton.setEnabled(Laby.labyAPI().minecraft().isIngame());
        menu.addEntry((Widget)addButton);
        this.editButton = ButtonWidget.i18n((String)"labymod.ui.button.edit", () -> this.setAction(Action.EDIT));
        this.editButton.setEnabled(this.selectedWaypoint != null);
        menu.addEntry((Widget)this.editButton);
        this.removeButton = ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> this.setAction(Action.REMOVE));
        this.removeButton.setEnabled(this.selectedWaypoint != null);
        menu.addEntry((Widget)this.removeButton);
        container.addContent((Widget)menu);
        ((Document)this.document()).addChild((Widget)container);
    }

    public ArrayList<WaypointListItemWidget> getWaypointWidgets() {
        return this.waypointWidgets;
    }

    public boolean hasVisibleWaypoint() {
        for (Waypoint waypoint : this.waypointService.getAll()) {
            if (!waypoint.meta().isVisible()) continue;
            return true;
        }
        return false;
    }

    public void handleWaypointWidgetStyle(WaypointListItemWidget waypointWidget, boolean visibility) {
        waypointWidget.getWaypointMeta().setVisible(visibility);
        this.waypointService.update(waypointWidget.getWaypointMeta());
        this.waypointService.refresh();
        waypointWidget.opacity().set((Object)Float.valueOf(visibility ? 1.0f : 0.5f));
        waypointWidget.getCheckbox().setState(visibility ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        boolean bl;
        try {
            bl = super.mouseClicked(mouse, mouseButton);
        }
        catch (Throwable throwable) {
            this.selectedWaypoint = (WaypointListItemWidget)((Object)this.waypointList.listSession().getSelectedEntry());
            this.removeButton.setEnabled(this.selectedWaypoint != null);
            this.editButton.setEnabled(this.selectedWaypoint != null);
            throw throwable;
        }
        this.selectedWaypoint = (WaypointListItemWidget)((Object)this.waypointList.listSession().getSelectedEntry());
        this.removeButton.setEnabled(this.selectedWaypoint != null);
        this.editButton.setEnabled(this.selectedWaypoint != null);
        return bl;
    }

    public boolean keyPressed(Key key, InputType type) {
        return super.keyPressed(key, type);
    }

    public void setAction(Action action) {
        switch (action.ordinal()) {
            case 1: {
                ManageWaypointSimplePopup editWaypointPopup = new ManageWaypointSimplePopup(this.selectedWaypoint.getWaypointMeta()).onSave(waypoint -> {
                    this.updateWaypointContextList();
                    this.reload();
                });
                editWaypointPopup.displayInOverlay();
                break;
            }
            case 2: {
                if (this.selectedWaypoint == null) {
                    return;
                }
                WaypointMeta waypointMeta = this.selectedWaypoint.getWaypointMeta();
                this.waypointService.remove(waypointMeta);
                this.waypointList.listSession().setSelectedEntry(null);
                this.selectedWaypoint = null;
                this.updateWaypointContextList();
                this.reload();
                this.waypointService.refresh();
                break;
            }
            default: {
                ManageWaypointSimplePopup addWaypointPopup = new ManageWaypointSimplePopup().onSave(() -> {
                    this.updateWaypointContextList();
                    this.reload();
                });
                addWaypointPopup.displayInOverlay();
            }
        }
    }

    public static enum Action {
        ADD,
        EDIT,
        REMOVE;

    }
}

