/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.listener;

import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.WaypointsAddon;
import net.labymod.addons.waypoints.core.WaypointsConfiguration;
import net.labymod.addons.waypoints.core.activity.popup.ManageWaypointSimplePopup;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.api.Laby;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.input.KeyEvent;

public class WaypointHotkeyListener {
    private final WaypointsAddon addon;

    public WaypointHotkeyListener(WaypointsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void createWaypoints(KeyEvent event) {
        if (event.state() != KeyEvent.State.PRESS || Laby.labyAPI().minecraft().minecraftWindow().isScreenOpened()) {
            return;
        }
        WaypointsConfiguration config = (WaypointsConfiguration)this.addon.configuration();
        if (config.createKey().get() == event.key()) {
            new ManageWaypointSimplePopup().displayAsActivity();
            return;
        }
        if (config.editClosestKey().get() != event.key()) {
            return;
        }
        WaypointService waypointService = Waypoints.references().waypointService();
        Waypoint closest = null;
        for (Waypoint waypoint : waypointService.getVisible()) {
            double distance = waypoint.waypointObjectMeta().getDistance();
            if (!(distance <= 15.0)) continue;
            if (closest == null) {
                closest = waypoint;
                continue;
            }
            if (!(distance < closest.waypointObjectMeta().getDistance())) continue;
            closest = waypoint;
        }
        if (closest == null) {
            this.addon.labyAPI().minecraft().chatExecutor().displayClientMessage("No Waypoint to edit within 15 blocks found.");
            return;
        }
        new ManageWaypointSimplePopup(closest).displayAsActivity();
    }
}

