/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.widgets;

import net.labymod.addons.waypoints.core.activity.WaypointsActivity;
import net.labymod.addons.waypoints.core.activity.widgets.WaypointListItemWidget;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;

@AutoWidget
public class HeaderWidget
extends SimpleWidget {
    private final WaypointsActivity activity;
    private final CheckBoxWidget checkbox = new CheckBoxWidget();
    private final ComponentWidget title;

    public HeaderWidget(WaypointsActivity activity) {
        this.activity = activity;
        this.title = ComponentWidget.component((Component)Component.translatable((String)"labyswaypoints.gui.showWaypoints", (Component[])new Component[0]));
        this.title.addId("title");
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.checkbox.setState(this.activity.hasVisibleWaypoint() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        this.checkbox.setPressable(() -> this.handleWaypointWidgetStyle());
        this.checkbox.addId("checkbox");
        this.addChild((Widget)this.checkbox);
        this.addChild((Widget)this.title);
    }

    public void handleWaypointWidgetStyle() {
        for (WaypointListItemWidget waypointWidget : this.activity.getWaypointWidgets()) {
            this.activity.handleWaypointWidgetStyle(waypointWidget, this.checkbox.state() == CheckBoxWidget.State.CHECKED);
        }
    }

    public CheckBoxWidget getCheckbox() {
        return this.checkbox;
    }
}

