/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.activity.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.overlay.WidgetReference;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.GridWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.gui.window.Window;
import net.labymod.api.util.bounds.ModifyReason;
import net.labymod.api.util.bounds.MutableRectangle;
import org.jetbrains.annotations.NotNull;

@AutoWidget
@Link(value="manage-popup.lss")
public class IconPickerWidget
extends ButtonWidget {
    private static final ModifyReason DROPDOWN_POSITION = ModifyReason.of((String)"dropdownPosition");
    private final List<Icon> icons = new ArrayList<Icon>();
    private Icon selectedIcon;
    private Consumer<Icon> changeListener;
    private WidgetReference reference;

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.icon().set((Object)this.selectedIcon);
    }

    public boolean onPress() {
        if (this.reference != null && this.reference.isAlive()) {
            this.reference.remove();
            this.reference = null;
            return true;
        }
        GridWidget grid = new GridWidget();
        grid.addId("icon-picker-grid");
        for (Icon icon : this.icons) {
            icon.aspectRatio(1.0f);
            IconWidget iconWidget = new IconWidget(icon);
            iconWidget.setPressable(() -> {
                this.setSelected(icon);
                if (this.changeListener != null) {
                    this.changeListener.accept(icon);
                }
            });
            grid.addChild((Widget)iconWidget);
        }
        this.reference = this.displayInOverlay((Widget)grid);
        this.reference.boundsUpdater((ref, bounds) -> {
            Window window = this.labyAPI.minecraft().minecraftWindow();
            MutableRectangle attachTo = Bounds.absoluteBounds((Parent)this);
            boolean dropUp = attachTo.getY() > (float)window.getScaledHeight() / 2.0f;
            float padding = 2.0f;
            float width = attachTo.getWidth() - padding;
            float height = ref.widget().getEffectiveHeight();
            bounds.setSize(width, height, DROPDOWN_POSITION);
            float x = attachTo.getX() + padding;
            float y = attachTo.getY() + (dropUp ? -height - padding : attachTo.getHeight() + padding);
            bounds.setPosition(x, y, DROPDOWN_POSITION);
            grid.updateBounds();
        });
        return super.onPress();
    }

    public void dispose() {
        super.dispose();
        if (this.reference != null && this.reference.isAlive()) {
            this.reference.remove();
            this.reference = null;
        }
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelected(@NotNull Icon icon) {
        this.selectedIcon = icon;
        this.updateIcon(icon);
    }

    public void addAll(Collection<Icon> icons) {
        this.icons.addAll(icons);
    }

    public void setChangeListener(Consumer<Icon> callback) {
        this.changeListener = callback;
    }
}

