/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.waypoints.core.listener;

import java.util.function.Consumer;
import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.core.WaypointsAddon;
import net.labymod.addons.waypoints.core.WaypointsConfiguration;
import net.labymod.addons.waypoints.core.waypoint.DefaultWaypoint;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointObjectMeta;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.render.GameRenderEvent;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.position.Position;
import net.labymod.api.util.math.vector.DoubleVector3;

public class WaypointUpdateListener {
    private static final float DEFAULT_SIZE = 0.7f;
    private static final int TARGET_DISTANCE = 128;
    private static final int FADE_OUT_DISTANCE = 8;
    private final WaypointService waypointService = Waypoints.references().waypointService();
    private double prevX = 0.0;
    private double prevY = 0.0;
    private double prevZ = 0.0;
    private boolean scaleDynamically;
    private boolean hideWhenOutOfRange;
    private double outOfRangeDistance;
    private boolean fadeOut;

    public WaypointUpdateListener(WaypointsAddon addon) {
        WaypointsConfiguration configuration = (WaypointsConfiguration)addon.configuration();
        this.apply(configuration.scaleDynamically(), value -> {
            this.scaleDynamically = value;
        });
        this.apply(configuration.hideWhenOutOfRange(), value -> {
            this.hideWhenOutOfRange = value;
        });
        this.apply(configuration.outOfRangeDistance(), value -> {
            this.outOfRangeDistance = value.intValue();
        });
        this.apply(configuration.fadeOut(), value -> {
            this.fadeOut = value;
        });
    }

    @Subscribe
    public void onGameRender(GameRenderEvent event) {
        Minecraft minecraft = Laby.labyAPI().minecraft();
        ClientPlayer player = minecraft.getClientPlayer();
        if (player == null || !minecraft.isIngame() || event.phase() != Phase.PRE) {
            return;
        }
        Position playerPosition = player.position();
        double x = playerPosition.getX();
        double y = playerPosition.getY() + (double)player.getEyeHeight();
        double z = playerPosition.getZ();
        boolean update = !this.waypointService.isWaypointsRenderCache() || x != this.prevX || y != this.prevY || z != this.prevZ;
        this.prevX = x;
        this.prevY = y;
        this.prevZ = z;
        int renderDistance = Laby.labyAPI().minecraft().options().getActualRenderDistance() * 16;
        float partialTicks = event.getPartialTicks();
        for (Waypoint waypoint : this.waypointService.getVisible()) {
            WaypointObjectMeta objectMeta;
            if (update) {
                this.updateWaypoint(x, y, z, waypoint, renderDistance);
            }
            if ((objectMeta = waypoint.waypointObjectMeta()).isOutOfRange() || !(waypoint instanceof DefaultWaypoint)) continue;
            DefaultWaypoint defaultWaypoint = (DefaultWaypoint)waypoint;
            DoubleVector3 pos = objectMeta.pos();
            DoubleVector3 previousPosition = waypoint.previousPosition();
            boolean hasPrevPosition = defaultWaypoint.hasPrevPosition();
            if (hasPrevPosition && previousPosition.getX() == pos.getX() && previousPosition.getY() == pos.getY() && previousPosition.getZ() == pos.getZ()) continue;
            defaultWaypoint.applyPreviousPosition();
            if (defaultWaypoint.waypointObjectMeta().isInterpolatePosition() && hasPrevPosition) {
                double previousX = previousPosition.getX();
                double previousY = previousPosition.getY();
                double previousZ = previousPosition.getZ();
                waypoint.position().set(MathHelper.lerp((double)pos.getX(), (double)previousX, (float)partialTicks), MathHelper.lerp((double)pos.getY(), (double)previousY, (float)partialTicks), MathHelper.lerp((double)pos.getZ(), (double)previousZ, (float)partialTicks));
                continue;
            }
            waypoint.position().set(pos);
        }
        if (update) {
            this.waypointService.setWaypointsRenderCache(true);
        }
    }

    private void updateWaypoint(double playerX, double playerY, double playerZ, Waypoint waypoint, int renderDistance) {
        float scale;
        DoubleVector3 location = waypoint.meta().location();
        double distanceX = playerX - location.getX();
        double distanceY = playerY - location.getY();
        double distanceZ = playerZ - location.getZ();
        double distanceSquared = MathHelper.square((double)distanceX) + MathHelper.square((double)distanceY) + MathHelper.square((double)distanceZ);
        double distanceToPlayer = Math.sqrt(distanceSquared);
        WaypointObjectMeta waypointObjectMeta = waypoint.waypointObjectMeta();
        waypointObjectMeta.setDistance(distanceToPlayer);
        if (!this.scaleDynamically) {
            waypointObjectMeta.setOutOfRange(distanceToPlayer > (double)renderDistance);
            if (!waypointObjectMeta.isOutOfRange() && distanceToPlayer > (double)(renderDistance - 8)) {
                float alpha = (float)(1.0 - (distanceToPlayer - (double)(renderDistance - 8)) / 8.0);
                waypointObjectMeta.setAlpha(alpha);
            } else {
                waypointObjectMeta.setAlpha(1.0f);
            }
            waypointObjectMeta.setScale(0.7f);
            waypointObjectMeta.pos().set(location);
            waypointObjectMeta.setInterpolatePosition(false);
            if (waypoint instanceof DefaultWaypoint) {
                DefaultWaypoint defaultWaypoint = (DefaultWaypoint)waypoint;
                defaultWaypoint.setHasPrevPosition(false);
            }
            return;
        }
        waypointObjectMeta.setAlpha(1.0f);
        if (this.hideWhenOutOfRange) {
            if (distanceToPlayer > this.outOfRangeDistance) {
                waypointObjectMeta.setOutOfRange(true);
                waypointObjectMeta.pos().set(location);
                waypointObjectMeta.setInterpolatePosition(false);
                if (waypoint instanceof DefaultWaypoint) {
                    DefaultWaypoint defaultWaypoint = (DefaultWaypoint)waypoint;
                    defaultWaypoint.setHasPrevPosition(false);
                }
                return;
            }
            if (this.fadeOut && distanceToPlayer > this.outOfRangeDistance - 8.0) {
                float alpha = (float)(1.0 - (distanceToPlayer - (this.outOfRangeDistance - 8.0)) / 8.0);
                waypointObjectMeta.setAlpha(alpha);
            }
        }
        int targetDistance = 128;
        if (distanceToPlayer < 10.0) {
            scale = 0.7f;
        } else if (distanceToPlayer < (double)targetDistance) {
            float normalizedDistance = (float)((distanceToPlayer -= 10.0) / (double)targetDistance);
            float factor = 5.0f + 2.0f * normalizedDistance;
            scale = 0.7f + factor * normalizedDistance;
        } else {
            scale = 7.0f;
        }
        waypointObjectMeta.setScale(scale);
        waypointObjectMeta.setOutOfRange(false);
    }

    private <T> void apply(ConfigProperty<T> property, Consumer<T> consumer) {
        consumer.accept(property.get());
        property.addChangeListener(newValue -> {
            consumer.accept(newValue);
            this.waypointService.setWaypointsRenderCache(false);
        });
    }
}

