/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.widgets.LeaderboardEntryWidget;
import de.timuuuu.moneymaker.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@AutoActivity
@Links(value={@Link(value="leaderboard.lss"), @Link(value="buttons.lss")})
public class LeaderboardActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private SortType sorting = SortType.RANKING;
    private SortDirection sortDirection = SortDirection.ASC;
    private List<LeaderboardEntryWidget> entries = new ArrayList<LeaderboardEntryWidget>();
    private final int updateTime = 600000;
    private long updateCoolDown = 0L;

    public LeaderboardActivity(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.leaderboard.title").addId("title");
        ((Document)this.document).addChild((Widget)titleWidget);
        DivWidget container = new DivWidget();
        container.addId("container");
        ComponentWidget liveDataInfoWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.leaderboard.liveDataInfo").addId("liveData-info");
        container.addChild((Widget)liveDataInfoWidget);
        ButtonWidget toggleBlocksButton = (ButtonWidget)ButtonWidget.component((Component)Component.translatable((String)("moneymaker.ui.leaderboard.toggleBlocks." + (this.addon.addonUtil().leaderboardShowBlocks() ? "enabled" : "disabled")), (TextColor)NamedTextColor.YELLOW)).addId("toggle-blocks-button");
        toggleBlocksButton.setPressable(() -> {
            if (this.addon.addonUtil().leaderboardShowBlocks()) {
                this.addon.addonUtil().leaderboardShowBlocks(false);
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.leaderboard.title", (TextColor)NamedTextColor.GOLD), ((TranslatableComponent)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.disabled", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.info", (TextColor)NamedTextColor.GRAY)));
            } else {
                this.addon.addonUtil().leaderboardShowBlocks(true);
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.leaderboard.title", (TextColor)NamedTextColor.GOLD), ((TranslatableComponent)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.enabled", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.info", (TextColor)NamedTextColor.GRAY)));
            }
            toggleBlocksButton.updateComponent((Component)Component.translatable((String)("moneymaker.ui.leaderboard.toggleBlocks." + (this.addon.addonUtil().leaderboardShowBlocks() ? "enabled" : "disabled")), (TextColor)NamedTextColor.YELLOW));
        });
        container.addChild((Widget)toggleBlocksButton);
        ButtonWidget updateButton = (ButtonWidget)ButtonWidget.component((Component)Component.translatable((String)"moneymaker.ui.leaderboard.update", (TextColor)NamedTextColor.GREEN)).addId("update-button");
        updateButton.setPressable(() -> {
            Objects.requireNonNull(this);
            long remaining = this.updateCoolDown + 600000L - System.currentTimeMillis();
            if (remaining > 0L) {
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.leaderboard.title", (TextColor)NamedTextColor.GOLD), (Component)Component.translatable((String)"moneymaker.notification.leaderboard.coolDown", (TextColor)NamedTextColor.RED));
                return;
            }
            this.addon.apiUtil().loadLeaderboard(true);
            this.updateCoolDown = System.currentTimeMillis();
        });
        container.addChild((Widget)updateButton);
        if (!this.entries.isEmpty()) {
            if (this.sorting == SortType.USERNAME) {
                Comparator<LeaderboardEntryWidget> comparator = Comparator.comparing(entry -> entry.playerName().toLowerCase());
                if (this.sortDirection == SortDirection.DESC) {
                    comparator = comparator.reversed();
                }
                this.entries.sort(comparator);
            }
            if (this.sorting == SortType.RANKING) {
                this.entries.sort(Comparator.comparing(LeaderboardEntryWidget::ranking));
                if (this.sortDirection == SortDirection.DESC) {
                    Collections.reverse(this.entries);
                }
            }
            if (this.sorting == SortType.BLOCKS) {
                this.entries.sort(Comparator.comparing(LeaderboardEntryWidget::blocks));
                if (this.sortDirection == SortDirection.DESC) {
                    Collections.reverse(this.entries);
                }
            }
            if (this.sorting == SortType.PICKAXE) {
                this.entries.sort(Comparator.comparing(LeaderboardEntryWidget::pickaxeRanking));
                if (this.sortDirection == SortDirection.DESC) {
                    Collections.reverse(this.entries);
                }
            }
            if (this.sorting == SortType.SWORD) {
                this.entries.sort(Comparator.comparing(LeaderboardEntryWidget::swordRanking));
                if (this.sortDirection == SortDirection.DESC) {
                    Collections.reverse(this.entries);
                }
            }
            HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
            TranslatableComponent username = Component.translatable((String)"moneymaker.ui.leaderboard.header.username", (Component[])new Component[0]);
            if (this.sorting == SortType.USERNAME) {
                username.append((Component)(this.sortDirection == SortDirection.DESC ? Component.text((String)" \u25b2") : Component.text((String)" \u25bc")));
            }
            ComponentWidget usernameWidget = ComponentWidget.component((Component)username);
            usernameWidget.setPressable(() -> {
                if (this.sorting == SortType.USERNAME) {
                    this.sortDirection = this.sortDirection == SortDirection.ASC ? SortDirection.DESC : SortDirection.ASC;
                } else {
                    this.sorting = SortType.USERNAME;
                }
                this.reload();
            });
            TranslatableComponent ranking = Component.translatable((String)"moneymaker.ui.leaderboard.header.ranking", (Component[])new Component[0]);
            if (this.sorting == SortType.RANKING) {
                ranking.append((Component)(this.sortDirection == SortDirection.DESC ? Component.text((String)" \u25b2") : Component.text((String)" \u25bc")));
            }
            ComponentWidget rankingWidget = ComponentWidget.component((Component)ranking);
            rankingWidget.setPressable(() -> {
                if (this.sorting == SortType.RANKING) {
                    this.sortDirection = this.sortDirection == SortDirection.ASC ? SortDirection.DESC : SortDirection.ASC;
                } else {
                    this.sorting = SortType.RANKING;
                }
                this.reload();
            });
            TranslatableComponent blocks = Component.translatable((String)"moneymaker.ui.leaderboard.header.blocks", (Component[])new Component[0]);
            if (this.sorting == SortType.BLOCKS) {
                blocks.append((Component)(this.sortDirection == SortDirection.DESC ? Component.text((String)" \u25b2") : Component.text((String)" \u25bc")));
            }
            ComponentWidget blocksWidget = ComponentWidget.component((Component)blocks);
            blocksWidget.setPressable(() -> {
                if (this.sorting == SortType.BLOCKS) {
                    this.sortDirection = this.sortDirection == SortDirection.ASC ? SortDirection.DESC : SortDirection.ASC;
                } else {
                    this.sorting = SortType.BLOCKS;
                }
                this.reload();
            });
            TranslatableComponent pickaxe = Component.translatable((String)"moneymaker.ui.leaderboard.header.pickaxe", (Component[])new Component[0]);
            if (this.sorting == SortType.PICKAXE) {
                pickaxe.append((Component)(this.sortDirection == SortDirection.DESC ? Component.text((String)" \u25b2") : Component.text((String)" \u25bc")));
            }
            ComponentWidget pickaxeWidget = ComponentWidget.component((Component)pickaxe);
            pickaxeWidget.setPressable(() -> {
                if (this.sorting == SortType.PICKAXE) {
                    this.sortDirection = this.sortDirection == SortDirection.ASC ? SortDirection.DESC : SortDirection.ASC;
                } else {
                    this.sorting = SortType.PICKAXE;
                }
                this.reload();
            });
            TranslatableComponent sword = Component.translatable((String)"moneymaker.ui.leaderboard.header.sword", (Component[])new Component[0]);
            if (this.sorting == SortType.SWORD) {
                sword.append((Component)(this.sortDirection == SortDirection.DESC ? Component.text((String)" \u25b2") : Component.text((String)" \u25bc")));
            }
            ComponentWidget swordWidget = ComponentWidget.component((Component)sword);
            swordWidget.setPressable(() -> {
                if (this.sorting == SortType.SWORD) {
                    this.sortDirection = this.sortDirection == SortDirection.ASC ? SortDirection.DESC : SortDirection.ASC;
                } else {
                    this.sorting = SortType.SWORD;
                }
                this.reload();
            });
            header.addEntry(usernameWidget.addId(new String[]{"username", this.sorting == SortType.USERNAME ? "active" : ""}));
            header.addEntry(rankingWidget.addId(new String[]{"ranking", this.sorting == SortType.RANKING ? "active" : ""}));
            header.addEntry(blocksWidget.addId(new String[]{"blocks", this.sorting == SortType.BLOCKS ? "active" : ""}));
            header.addEntry(pickaxeWidget.addId(new String[]{"pickaxe-ranking", this.sorting == SortType.PICKAXE ? "active" : ""}));
            header.addEntry(swordWidget.addId(new String[]{"sword-ranking", this.sorting == SortType.SWORD ? "active" : ""}));
            container.addChild((Widget)header);
            VerticalListWidget listWidget = (VerticalListWidget)new VerticalListWidget().addId("entries");
            this.entries.forEach(entry -> {
                if (entry.ranking() != 0) {
                    listWidget.addChild((Widget)entry);
                }
            });
            container.addChild(new ScrollWidget((Widget)listWidget, new ListSession()).addId("leaderboard-scroll"));
        } else {
            container.addChild(ComponentWidget.i18n((String)"moneymaker.ui.leaderboard.noData", (TextColor)NamedTextColor.DARK_RED).addId("error-text"));
        }
        ((Document)this.document).addChild((Widget)container);
        ((Document)this.document).addChild((Widget)Util.feedbackButton());
        ((Document)this.document).addChild((Widget)Util.discordButton());
        ((Document)this.document).addChild((Widget)Util.leaderboardButton());
        Util.addCredits(this.addon, (Document)this.document);
    }

    public List<LeaderboardEntryWidget> entries() {
        return this.entries;
    }

    public static enum SortType {
        USERNAME("username"),
        RANKING("ranking"),
        BLOCKS("blocks"),
        PICKAXE("pickaxe"),
        SWORD("sword");

        private final String translation;

        private SortType(String translation) {
            this.translation = translation;
        }

        public String translation() {
            return this.translation;
        }
    }

    public static enum SortDirection {
        ASC("asc"),
        DESC("desc");

        private final String translation;

        private SortDirection(String translation) {
            this.translation = translation;
        }

        public String translation() {
            return this.translation;
        }
    }
}

