/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.popup;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserMute;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import de.timuuuu.moneymaker.utils.Util;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.TimeUnit;

@Link(value="popup/mute.lss")
@AutoActivity
public class MuteActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private UUID executorUUID;
    private String executorName;
    private MoneyChatMessage chatMessage;
    private UUID uuid;
    private String userName;
    private String reason;
    private ScreenInstance previousScreen;
    private TextFieldWidget reasonInput;
    private TextFieldWidget durationInput;

    public MuteActivity(MoneyMakerAddon addon, UUID executorUUID, String executorName, MoneyChatMessage chatMessage, ScreenInstance previousScreen) {
        this.addon = addon;
        this.executorUUID = executorUUID;
        this.executorName = executorName;
        this.chatMessage = chatMessage;
        this.uuid = chatMessage.uuid();
        this.userName = chatMessage.userName();
        this.previousScreen = previousScreen;
    }

    public MuteActivity(MoneyMakerAddon addon, UUID executorUUID, String executorName, String userName, UUID uuid, ScreenInstance previousScreen, String reason) {
        this.addon = addon;
        this.executorUUID = executorUUID;
        this.executorName = executorName;
        this.uuid = uuid;
        this.userName = userName;
        this.previousScreen = previousScreen;
        this.reason = reason;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.mute.form.title", (Object[])new Object[]{this.userName}).addId("title");
        header.addEntry((Widget)headWidget);
        header.addEntry((Widget)titleWidget);
        ComponentWidget messageTitleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.mute.form.message").addId("message-title");
        TextFieldWidget messageInputWidget = (TextFieldWidget)new TextFieldWidget().addId("message-input");
        messageInputWidget.setEditable(false);
        if (this.chatMessage != null) {
            messageInputWidget.setText(this.chatMessage.message());
        }
        ComponentWidget reasonTitleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.mute.form.reason").addId("reason-title");
        this.reasonInput = (TextFieldWidget)new TextFieldWidget().addId("reason-input");
        if (this.reason != null) {
            this.reasonInput.setText(this.reason);
        }
        ComponentWidget durationTitleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.mute.form.duration").addId("duration-title");
        this.durationInput = (TextFieldWidget)new TextFieldWidget().addId("duration-input");
        this.durationInput.placeholder((Component)Component.text((String)"7d 2h 10m"));
        ButtonWidget sendButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.mute.form.send").addId("send-button");
        sendButton.setPressable(this::sendForm);
        ButtonWidget closeButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.mute.form.close").addId("close-button");
        closeButton.setPressable(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen));
        FlexibleContentWidget buttonContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("button-container");
        buttonContainer.addContent((Widget)sendButton);
        buttonContainer.addContent((Widget)closeButton);
        FlexibleContentWidget content = (FlexibleContentWidget)new FlexibleContentWidget().addId("content");
        FlexibleContentWidget messageContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("message-container");
        messageContainer.addContent((Widget)messageTitleWidget);
        messageContainer.addContent((Widget)messageInputWidget);
        content.addContent((Widget)messageContainer);
        FlexibleContentWidget reasonContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("reason-container");
        reasonContainer.addContent((Widget)reasonTitleWidget);
        reasonContainer.addContent((Widget)this.reasonInput);
        content.addContent((Widget)reasonContainer);
        FlexibleContentWidget durationContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("duration-container");
        durationContainer.addContent((Widget)durationTitleWidget);
        durationContainer.addContent((Widget)this.durationInput);
        content.addContent((Widget)durationContainer);
        content.addContent((Widget)buttonContainer);
        container.addContent((Widget)header);
        container.addContent((Widget)content);
        ((Document)this.document).addChild((Widget)container);
    }

    private void sendForm() {
        if (!Util.isStaff(this.executorUUID)) {
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.mute.form.invalid.title", (TextColor)NamedTextColor.DARK_RED), (Component)Component.translatable((String)"moneymaker.mute.form.invalid.noStaff", (TextColor)NamedTextColor.RED));
            return;
        }
        if (this.reasonInput.getText().isBlank()) {
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.mute.form.invalid.title", (TextColor)NamedTextColor.DARK_RED), (Component)Component.translatable((String)"moneymaker.mute.form.invalid.noReason", (TextColor)NamedTextColor.RED));
            return;
        }
        long duration = TimeUnit.parseToLong((String)this.durationInput.getText());
        if (duration <= 0L) {
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.mute.form.invalid.title", (TextColor)NamedTextColor.DARK_RED), (Component)Component.translatable((String)"moneymaker.mute.form.invalid.invalidDuration", (TextColor)NamedTextColor.RED));
            return;
        }
        this.addon.moneyChatClient().sendPacket(new PacketUserMute(this.executorUUID, this.executorName, this.uuid, this.userName, this.reasonInput.getText(), this.chatMessage != null ? this.chatMessage.messageId() : "-", duration));
        Laby.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen);
        this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.mute.form.success.title", (TextColor)NamedTextColor.DARK_GREEN), (Component)Component.translatable((String)"moneymaker.mute.form.success.text", (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{Component.text((String)this.userName, (TextColor)NamedTextColor.YELLOW), Component.text((String)this.reasonInput.getText(), (TextColor)NamedTextColor.YELLOW), Component.text((String)TimeUnit.parseToString((long)duration), (TextColor)NamedTextColor.YELLOW)}));
    }
}

