/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.widgets;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.popup.ChatReportActivity;
import de.timuuuu.moneymaker.activities.popup.MuteActivity;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessageDelete;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import de.timuuuu.moneymaker.utils.MoneyTextures;
import de.timuuuu.moneymaker.utils.Util;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.component.serializer.plain.PlainTextComponentSerializer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.user.group.Group;

public class ChatMessageWidget
extends FlexibleContentWidget {
    private MoneyMakerAddon addon;
    private String time;
    private MoneyChatMessage chatMessage = null;
    private Component customMessage;
    private MoneyChatMessage.MessageType messageType;

    public ChatMessageWidget(MoneyMakerAddon addon, String time, MoneyChatMessage chatMessage) {
        this.addon = addon;
        this.time = time;
        this.chatMessage = chatMessage;
        this.messageType = chatMessage.messageType();
    }

    public ChatMessageWidget(MoneyMakerAddon addon, String time, Component customMessage) {
        this.addon = addon;
        this.time = time;
        this.customMessage = customMessage;
        this.messageType = MoneyChatMessage.MessageType.SERVER;
    }

    public void initialize(Parent parent) {
        ComponentWidget componentMessageWidget;
        super.initialize(parent);
        UUID uuid = Laby.labyAPI().getUniqueId();
        VerticalListWidget flex = (VerticalListWidget)new VerticalListWidget().addId("flex");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("message-header");
        if (this.messageType == MoneyChatMessage.MessageType.PLAYER) {
            header.addEntry(new IconWidget(Icon.head((UUID)this.chatMessage.uuid())).addId("avatar"));
            Group labyRank = Laby.references().gameUserService().gameUser(this.chatMessage.uuid()).visibleGroup();
            if (!labyRank.isDefault()) {
                IconWidget labyIconWidget = (IconWidget)new IconWidget(Textures.SpriteLabyMod.WHITE_WOLF_HIGH_RES).addId("labymod-rank");
                labyIconWidget.color().set((Object)labyRank.getColor().getRGB());
                if (labyRank.getTagName() != null) {
                    labyIconWidget.setHoverComponent(((TextComponent)((TextComponent)Component.text((String)"LABYMOD", (TextColor)NamedTextColor.WHITE).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" "))).append(Component.text((String)labyRank.getTagName()).color(labyRank.getTextColor())));
                }
                header.addEntry((Widget)labyIconWidget);
            }
            if (this.chatMessage.group().isStaff()) {
                IconWidget staffIconWidget = (IconWidget)new IconWidget(this.chatMessage.group().getIcon()).addId("mma-rank");
                if (this.chatMessage.group().getTagName() != null) {
                    staffIconWidget.setHoverComponent(((TextComponent)((TextComponent)Component.text((String)"MoneyMaker-Addon", (TextColor)NamedTextColor.YELLOW).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" "))).append(Component.text((String)this.chatMessage.group().getTagName()).color(this.chatMessage.group().getTextColor())));
                }
                header.addEntry((Widget)staffIconWidget);
            }
            TextComponent senderComponent = Component.text((String)this.chatMessage.userName(), (TextColor)this.chatMessage.group().getTextColor());
            senderComponent.clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + this.chatMessage().userName())));
            header.addEntry(ComponentWidget.component((Component)senderComponent).addId("sender"));
        } else {
            header.addEntry(new IconWidget(this.messageType.icon()).addId("avatar"));
            header.addEntry(ComponentWidget.component((Component)this.messageType.userName()).addId("sender"));
        }
        header.addEntry(ComponentWidget.text((String)this.time).addId("timestamp"));
        if (this.chatMessage != null && this.chatMessage.fromServerCache()) {
            ComponentWidget cacheInfoWidget = (ComponentWidget)ComponentWidget.component((Component)Component.icon((Icon)MoneyTextures.SpriteCommon.EXCLAMATION_MARK, (int)5)).addId("cache-info");
            cacheInfoWidget.setHoverComponent((Component)Component.translatable((String)"moneymaker.ui.chat.info.cache", (Component[])new Component[0]));
            header.addEntry((Widget)cacheInfoWidget);
        }
        if (Util.isStaff(uuid) && this.chatMessage != null) {
            if (!this.chatMessage.messageId().equals("UNKNOWN")) {
                header.addEntry(ComponentWidget.text((String)("(ID: " + this.chatMessage.messageId() + ")")).addId("message-id"));
            }
            if (this.chatMessage.deleted()) {
                header.addEntry(ComponentWidget.text((String)"(Gel\u00f6scht)").addId("deleted-info"));
            }
        }
        if (this.messageType == MoneyChatMessage.MessageType.PLAYER && this.chatMessage != null && !this.chatMessage.deleted()) {
            if (Util.isStaff(uuid)) {
                if (!this.chatMessage.uuid().equals(Laby.labyAPI().getUniqueId()) && !Util.isStaff(this.chatMessage.uuid())) {
                    ButtonWidget muteButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.chat.button.mute").addId("mute-button");
                    muteButton.setPressable(() -> Laby.labyAPI().minecraft().executeNextTick(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new MuteActivity(this.addon, Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), this.chatMessage, (ScreenInstance)Laby.labyAPI().minecraft().minecraftWindow().currentScreen()))));
                    header.addEntry((Widget)muteButton);
                }
            } else if (!Util.isAdmin(this.chatMessage.uuid()) && !this.chatMessage.uuid().equals(Laby.labyAPI().getUniqueId())) {
                ButtonWidget reportButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.chat.button.report").addId("report-button");
                reportButton.setPressable(() -> Laby.labyAPI().minecraft().executeNextTick(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new ChatReportActivity(this.addon, Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), this.chatMessage, (ScreenInstance)Laby.labyAPI().minecraft().minecraftWindow().currentScreen()))));
                header.addEntry((Widget)reportButton);
            }
        }
        if (this.chatMessage != null && !this.chatMessage.deleted() && Util.isStaff(uuid)) {
            ButtonWidget deleteButton = (ButtonWidget)ButtonWidget.deleteButton().addId("delete-button");
            deleteButton.setPressable(() -> this.addon.moneyChatClient().sendPacket(new PacketMessageDelete(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), this.chatMessage.messageId())));
            header.addEntry((Widget)deleteButton);
        }
        flex.addChild((Widget)header);
        VerticalListWidget messageContentWidget = (VerticalListWidget)new VerticalListWidget().addId("message-content");
        if (this.chatMessage != null) {
            componentMessageWidget = ComponentWidget.component((Component)PlainTextComponentSerializer.plainUrl().deserialize(this.chatMessage.message()));
            if (this.chatMessage.deleted()) {
                componentMessageWidget.addId("deleted");
            }
        } else {
            componentMessageWidget = ComponentWidget.component((Component)this.customMessage);
        }
        componentMessageWidget.addId(new String[]{"component-message", "tile"});
        messageContentWidget.addChild((Widget)componentMessageWidget);
        flex.addChild((Widget)messageContentWidget);
        this.addContent((Widget)flex);
    }

    public MoneyChatMessage chatMessage() {
        return this.chatMessage;
    }

    public MoneyChatMessage.MessageType messageType() {
        return this.messageType;
    }
}

