/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.widgets;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.MoneyPlayer;
import de.timuuuu.moneymaker.utils.Util;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.BorderRadius;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.user.group.Group;
import net.labymod.api.util.Color;
import net.labymod.api.util.I18n;

public class OnlineEntryWidget
extends FlexibleContentWidget {
    private MoneyMakerAddon addon;
    private boolean otherServers;
    private boolean hideOnlineStatus;
    private MoneyPlayer player;
    private boolean placeholder = false;
    private Component placeholderTitle = Component.text((String)"");

    public OnlineEntryWidget(MoneyMakerAddon addon, MoneyPlayer player, boolean otherServers, boolean hideOnlineStatus) {
        this.addon = addon;
        this.player = player;
        this.otherServers = otherServers;
        this.hideOnlineStatus = hideOnlineStatus;
    }

    public OnlineEntryWidget(MoneyMakerAddon addon, Component placeholderTitle) {
        this.addon = addon;
        this.placeholder = true;
        this.placeholderTitle = placeholderTitle;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        HorizontalListWidget entry = (HorizontalListWidget)new HorizontalListWidget().addId("head");
        if (this.placeholder) {
            this.addId("placeholder");
        }
        if (this.hideOnlineStatus) {
            this.backgroundColor().set((Object)Color.ofRGB((int)15, (int)17, (int)21).get());
            this.setBorderRadius(new BorderRadius(5.0f, 5.0f, 5.0f, 5.0f));
            this.paddingTop().set((Object)Float.valueOf(3.0f));
            this.setHoverComponent((Component)Component.text((String)"User has hidden his Online Status"));
        }
        entry.addEntry(new IconWidget(!this.placeholder ? Icon.head((UUID)this.player.uuid()) : Icon.texture((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"textures/icon.png"))).addId("avatar"));
        if (!this.placeholder) {
            Group labyRank = Laby.references().gameUserService().gameUser(this.player.uuid()).visibleGroup();
            if (!labyRank.isDefault()) {
                IconWidget labyIconWidget = (IconWidget)new IconWidget(Textures.SpriteLabyMod.WHITE_WOLF_HIGH_RES).addId("labymod-rank");
                labyIconWidget.color().set((Object)labyRank.getColor().getRGB());
                if (labyRank.getTagName() != null) {
                    labyIconWidget.setHoverComponent(((TextComponent)((TextComponent)Component.text((String)"LABYMOD", (TextColor)NamedTextColor.WHITE).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" "))).append(Component.text((String)labyRank.getTagName()).color(labyRank.getTextColor())));
                }
                entry.addEntry((Widget)labyIconWidget);
            }
            if (this.player.group().isStaff()) {
                IconWidget staffIconWidget = (IconWidget)new IconWidget(this.player.group().getIcon()).addId("mma-rank");
                if (this.player.group().getTagName() != null) {
                    staffIconWidget.setHoverComponent(((TextComponent)((TextComponent)Component.text((String)"MoneyMaker-Addon", (TextColor)NamedTextColor.YELLOW).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" "))).append(Component.text((String)this.player.group().getTagName()).color(this.player.group().getTextColor())));
                }
                entry.addEntry((Widget)staffIconWidget);
            }
            TextComponent nameComponent = Component.text((String)this.player.userName(), (TextColor)this.player.group().getTextColor());
            nameComponent.clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + this.player.userName())));
            entry.addEntry(ComponentWidget.component((Component)nameComponent).addId("userName"));
            if (Util.isAdmin(this.labyAPI.getUniqueId())) {
                Component addonVersionComponent = ((TextComponent)Component.text((String)"(", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)this.player.addonVersion(), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY));
                Component minecraftVersionComponent = ((TextComponent)Component.text((String)" (", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)("MC " + this.player.minecraftVersion()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY));
                Component versionComponent = addonVersionComponent.append(minecraftVersionComponent);
                entry.addEntry(ComponentWidget.component((Component)versionComponent).addId("versions"));
            }
        } else {
            entry.addEntry((Widget)ComponentWidget.component((Component)this.placeholderTitle));
        }
        HorizontalListWidget data = (HorizontalListWidget)new HorizontalListWidget().addId("data");
        if (!this.placeholder || this.otherServers) {
            Object server = this.player.server();
            if (((String)server).startsWith("Farming") && ((String)server).contains(" - ") && ((String)server).split(" - ").length == 2) {
                String cave = ((String)server).split(" - ")[1];
                server = "Farming - " + I18n.translate((String)this.addon.addonUtil().caveByName(cave).translation(), (Object[])new Object[0]);
            }
            Component component = ((TextComponent)((TextComponent)Component.text((String)"\u27a5 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"Server", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)":", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)server, (TextColor)NamedTextColor.GRAY));
            data.addEntry(ComponentWidget.component((Component)component).addId("currentServer"));
        }
        this.addContent((Widget)entry);
        this.addContent((Widget)data);
    }
}

