/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.badges;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.snapshot.MoneyMakerKeys;
import de.timuuuu.moneymaker.snapshot.MoneyPlayerSnapshot;
import net.labymod.api.client.entity.player.tag.tags.IconTag;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import org.jetbrains.annotations.Nullable;

public class MoneyIconTag
extends IconTag {
    private MoneyMakerAddon addon;
    @Nullable
    private Group group;

    public MoneyIconTag(MoneyMakerAddon addon) {
        super(9.0f);
        this.addon = addon;
    }

    public void begin(EntitySnapshot snapshot) {
        this.group = this.getVisibleGroup(snapshot);
        super.begin(snapshot);
    }

    public boolean isVisible() {
        return this.group != null && super.isVisible();
    }

    public Icon getIcon(EntitySnapshot snapshot) {
        if (this.group == null) {
            return GroupService.DEFAULT_GROUP.getIcon();
        }
        return this.group.getIcon() != null ? this.group.getIcon() : GroupService.DEFAULT_GROUP.getIcon();
    }

    @Nullable
    private Group getVisibleGroup(EntitySnapshot snapshot) {
        if (!this.visible(snapshot)) {
            return null;
        }
        if (!snapshot.has(MoneyMakerKeys.MONEY_PLAYER)) {
            return null;
        }
        MoneyPlayerSnapshot moneyPlayerSnapshot = (MoneyPlayerSnapshot)((Object)snapshot.get(MoneyMakerKeys.MONEY_PLAYER));
        if (moneyPlayerSnapshot.getMoneyPlayer() == null) {
            return null;
        }
        Group group = moneyPlayerSnapshot.getMoneyPlayer().group();
        return group.getDisplayType() == Group.GroupDisplay.BOTH || group.getDisplayType() == Group.GroupDisplay.BESIDE_NAME ? group : null;
    }

    private boolean visible(EntitySnapshot snapshot) {
        return (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).enabled().get() != false && (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).badgeConfiguration.iconTag().get() != false && !snapshot.isDiscrete() && !snapshot.isInvisible();
    }
}

