/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.badges;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.snapshot.MoneyMakerKeys;
import de.timuuuu.moneymaker.snapshot.MoneyPlayerSnapshot;
import java.util.List;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.util.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoneyTextTag
extends ComponentNameTag {
    private MoneyMakerAddon addon;
    @Nullable
    private Group group;

    public MoneyTextTag(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void begin(EntitySnapshot snapshot) {
        this.group = this.getVisibleGroup(snapshot);
        super.begin(snapshot);
    }

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        if (this.group == null) {
            return super.buildComponents(snapshot);
        }
        TextComponent groupDisplayName = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"MoneyMaker-Addon", (TextColor)TextColor.color((int)((Color)((MoneyMakerConfiguration)this.addon.configuration()).badgeConfiguration.textColor().get()).get())))).append((Component)Component.space())).append((Component)Component.text((String)this.group.getTagName(), (TextColor)this.group.getTextColor()))).build();
        return List.of(groupDisplayName);
    }

    public float getScale() {
        return 0.5f;
    }

    public boolean isVisible() {
        return this.group != null && super.isVisible();
    }

    @Nullable
    private Group getVisibleGroup(EntitySnapshot snapshot) {
        if (!this.visible(snapshot)) {
            return null;
        }
        if (!snapshot.has(MoneyMakerKeys.MONEY_PLAYER)) {
            return null;
        }
        MoneyPlayerSnapshot moneyPlayerSnapshot = (MoneyPlayerSnapshot)((Object)snapshot.get(MoneyMakerKeys.MONEY_PLAYER));
        if (moneyPlayerSnapshot.getMoneyPlayer() == null) {
            return null;
        }
        Group group = moneyPlayerSnapshot.getMoneyPlayer().group();
        return group.getDisplayType() == Group.GroupDisplay.BOTH || group.getDisplayType() == Group.GroupDisplay.ABOVE_HEAD ? group : null;
    }

    private boolean visible(EntitySnapshot snapshot) {
        return (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).enabled().get() != false && (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).badgeConfiguration.textTag().get() != false && !snapshot.isDiscrete() && !snapshot.isInvisible();
    }
}

