/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.boosters.BoosterUtil;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.chat.ChatReceiveEvent;
import net.labymod.api.util.concurrent.task.Task;

public class ChatReceiveListener {
    private MoneyMakerAddon addon;

    public ChatReceiveListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe(value=126)
    public void onChatReceive(ChatReceiveEvent event) {
        if (!this.addon.addonUtil().connectedToMoneyMaker()) {
            return;
        }
        String plain = event.chatMessage().getOriginalPlainText();
        if (plain.contains(this.addon.chatMessageLoader().message("chat.prefix"))) {
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.workplace.upgrade")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideWorkerUpgradeMessage().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.buyWorker.start")) && plain.contains(this.addon.chatMessageLoader().message("chat.buyWorker.contains")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideBuySellWorkerMessage().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.sellWorker.start")) && plain.contains(this.addon.chatMessageLoader().message("chat.sellWorker.contains")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideBuySellWorkerMessage().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.teleport.start")) && plain.contains(this.addon.chatMessageLoader().message("chat.teleport.contains")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideTeleportMessage().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if ((plain.equals(this.addon.chatMessageLoader().message("chat.spacerLine")) || plain.equals(this.addon.chatMessageLoader().message("chat.prefix"))) && (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideEmptyMessages().get()).booleanValue() || ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.shortBoosterMessage().get()).booleanValue())) {
                event.setCancelled(true);
            }
            if (plain.equals(this.addon.chatMessageLoader().message("chat.booster.found")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.shortBoosterMessage().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if (plain.contains("Booster (") && plain.contains(")") && !plain.contains(this.addon.chatMessageLoader().message("chat.booster.activated.3")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.shortBoosterMessage().get()).booleanValue()) {
                String boosterString = plain.replace(this.addon.chatMessageLoader().message("chat.prefix") + " ", "");
                String boostString = boosterString.split("\\(")[0].replace("%", "").replace("+", "").split(" ")[0];
                String timeString = plain.split(" \\(")[1].split(" ")[0];
                Booster booster = null;
                try {
                    int time;
                    if (plain.contains("Stunde") && plain.contains("Minuten") || plain.contains("hour") && plain.contains("minutes")) {
                        int hours = Util.parseInteger(plain.split(" \\(")[1].split(" ")[0], this.getClass());
                        int minutes = Util.parseInteger(plain.split(" \\(")[1].split(" ")[2], this.getClass());
                        time = minutes + hours * 60;
                    } else {
                        time = Util.parseInteger(timeString, this.getClass());
                        if (plain.contains("Stunde") || plain.contains("hour")) {
                            time *= 60;
                        }
                    }
                    int boost = Util.parseInteger(boostString, this.getClass());
                    booster = new Booster(boost, time);
                }
                catch (NumberFormatException time) {
                    // empty catch block
                }
                if (booster != null) {
                    TextColor color = BoosterUtil.getColor(booster);
                    Component message = this.addon.prefix.copy();
                    TextComponent boosterComponent = Component.text((String)(boosterString + " "), (TextColor)color);
                    message.append((Component)boosterComponent);
                    if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.showBoosterIcon().get()).booleanValue()) {
                        message.append((Component)Component.icon((Icon)BoosterUtil.getIcon(booster), (int)10)).append((Component)Component.text((String)" "));
                    }
                    message.append((Component)Component.translatable((String)"moneymaker.text.found", (TextColor)color));
                    this.addon.displayMessage(message);
                } else {
                    this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.text((String)(boosterString + " "), (TextColor)NamedTextColor.GREEN)).append((Component)Component.translatable((String)"moneymaker.text.found", (TextColor)NamedTextColor.GREEN)));
                }
                event.setCancelled(true);
            }
            if (plain.startsWith("[MoneyMaker] +") && plain.contains("Booster (")) {
                int boost = 0;
                int time = 0;
                try {
                    boost = Util.parseInteger(plain.split(" ")[1].replace("%", "").replace("+", ""), this.getClass());
                    if (plain.contains("Stunde") && plain.contains("Minuten") || plain.contains("hour") && plain.contains("minutes")) {
                        int hours = Util.parseInteger(plain.split(" \\(")[1].split(" ")[0], this.getClass());
                        int minutes = Util.parseInteger(plain.split(" \\(")[1].split(" ")[2], this.getClass());
                        time = minutes + hours * 60;
                    } else {
                        time = Util.parseInteger(plain.split(" \\(")[1].split(" ")[0], this.getClass());
                        if (plain.contains("Stunde") || plain.contains("hour")) {
                            time *= 60;
                        }
                    }
                }
                catch (NumberFormatException hours) {
                    // empty catch block
                }
                if (boost != 0 && time != 0) {
                    Booster.sessionBoost.addAndGet(boost);
                    Booster.sessionBoosters.addAndGet(1);
                    Booster.insertBooster(boost, time);
                    Booster.insertLatestBooster(boost, time);
                }
            }
            if (plain.equals(this.addon.chatMessageLoader().message("chat.workplace.unlocked"))) {
                this.addon.addonUtil().nextWorkerCost("X");
                this.addon.addonUtil().workerNotifySent(false);
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.debris.remove.start")) && plain.contains(this.addon.chatMessageLoader().message("chat.debris.remove.contains"))) {
                Task.builder(() -> {
                    this.addon.addonUtil().debrisCost("X");
                    this.addon.addonUtil().debrisNotifySent(false);
                }).delay(3L, TimeUnit.SECONDS).build().execute();
            }
            if (plain.equals(this.addon.chatMessageLoader().message("chat.workerEffect"))) {
                if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideEffectMessage().get()).booleanValue()) {
                    event.setCancelled(true);
                }
                if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.showTimersOnEffect().get()).booleanValue() && !((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideEffectMessage().get()).booleanValue()) {
                    AtomicInteger timers = new AtomicInteger();
                    Util.timers.values().forEach(timer -> {
                        if (timer.name().contains("Effekt-Timer-")) {
                            timers.getAndIncrement();
                        }
                    });
                    Component timer5m = Component.text((String)" [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"5m", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY)));
                    Component timer10m = Component.text((String)" [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"10m", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY)));
                    Component timer15m = Component.text((String)" [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"15m", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY)));
                    Component timer20m = Component.text((String)" [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"20m", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY)));
                    Component component = this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.text.effect-select", (TextColor)NamedTextColor.GRAY)).append(timer5m.clickEvent(ClickEvent.runCommand((String)("/mm-timer 5 Effekt-Timer-" + timers.get()))).append(timer10m.clickEvent(ClickEvent.runCommand((String)("/mm-timer 10 Effekt-Timer-" + timers.get())))).append(timer15m.clickEvent(ClickEvent.runCommand((String)("/mm-timer 15 Effekt-Timer-" + timers.get())))).append(timer20m.clickEvent(ClickEvent.runCommand((String)("/mm-timer 20 Effekt-Timer-" + timers.get())))));
                    Task.builder(() -> this.addon.displayMessage(component)).delay(50L, TimeUnit.MILLISECONDS).build().execute();
                }
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.booster.fullInventory")) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideFullBoosterInventory().get()).booleanValue()) {
                event.setCancelled(true);
            }
            if (plain.startsWith(this.addon.chatMessageLoader().message("chat.booster.activated.1")) && plain.contains(this.addon.chatMessageLoader().message("chat.booster.activated.2")) && plain.contains(this.addon.chatMessageLoader().message("chat.booster.activated.3"))) {
                if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.hideFullBoosterInventory().get()).booleanValue()) {
                    event.setCancelled(true);
                }
                String message = plain.split(" \\(")[0].replace(this.addon.chatMessageLoader().message("chat.booster.activated.1"), "").replace(this.addon.chatMessageLoader().message("chat.booster.activated.2"), "");
                try {
                    int boost = Util.parseInteger(message, this.getClass());
                    Booster.activatedBoost.addAndGet(boost);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

