/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.BoosterActivity;
import de.timuuuu.moneymaker.events.CaveLevelChangeEvent;
import de.timuuuu.moneymaker.events.MineSwitchEvent;
import de.timuuuu.moneymaker.events.MoneyChatReceiveEvent;
import de.timuuuu.moneymaker.events.MoneyPlayerStatusEvent;
import de.timuuuu.moneymaker.events.ProfileSwitchEvent;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.moneychat.MoneyChatClient;
import de.timuuuu.moneymaker.moneychat.event.MoneyChatDisconnectEvent;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketAddonStatistics;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketLeaderboard;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import de.timuuuu.moneymaker.settings.MoneyChatConfiguration;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.MoneyPlayer;
import de.timuuuu.moneymaker.utils.Util;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Constants;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.ShutdownEvent;
import net.labymod.api.event.client.network.server.ServerDisconnectEvent;
import net.labymod.api.event.client.network.server.ServerLoginEvent;
import net.labymod.api.event.client.session.SessionUpdateEvent;
import net.labymod.api.util.I18n;
import net.labymod.api.util.concurrent.task.Task;

public class MoneyAddonListener {
    private MoneyMakerAddon addon;
    private long lastMineUpdate = System.currentTimeMillis();
    private long lastLevelUpdate = System.currentTimeMillis();
    private AddonUtil.FarmingCave lastCave = AddonUtil.FarmingCave.UNKNOWN;

    public MoneyAddonListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onServerLogin(ServerLoginEvent event) {
        if (event.serverData().actualAddress().matches("gommehd.net", 25565, true) || event.serverData().actualAddress().matches("gommehd.fun", 25565, true) || event.serverData().actualAddress().matches("moneymaker.gg", 25565, true)) {
            this.addon.apiUtil().loadChatHistory();
        }
    }

    @Subscribe
    public void onDisconnect(ServerDisconnectEvent event) {
        if ((event.serverData().actualAddress().matches("gommehd.net", 25565, true) || event.serverData().actualAddress().matches("gommehd.fun", 25565, true) || event.serverData().actualAddress().matches("moneymaker.gg", 25565, true)) && this.addon.moneyChatClient().isAuthenticated()) {
            this.addon.moneyChatClient().sendPacket(new PacketLeaderboard(this.addon.labyAPI().getUniqueId(), this.addon.labyAPI().getName(), this.addon));
        }
        this.addon.addonUtil().resetValues(true);
        if (this.addon.moneyChatClient().isAuthenticated()) {
            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
        }
        this.addon.discordAPI().removeCustom();
        this.addon.discordAPI().removeSaved();
        this.addon.discordAPI().cancelUpdater();
    }

    @Subscribe
    public void onSessionUpdate(SessionUpdateEvent event) {
        if (this.addon.moneyChatClient().isAuthenticated()) {
            this.addon.moneyChatClient().sendPacket(new PacketAddonStatistics("remove", event.previousSession().getUniqueId(), event.previousSession().getUsername(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment()));
            this.addon.moneyChatClient().sendPacket(new PacketAddonStatistics("add", event.newSession().getUniqueId(), event.newSession().getUsername(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment()));
            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(event.previousSession().getUniqueId(), event.previousSession().getUsername(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(event.newSession().getUniqueId(), event.newSession().getUsername(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
            this.addon.moneyChatClient().sendPacket(new PacketLeaderboard(event.previousSession().getUniqueId(), event.previousSession().getUsername(), this.addon));
        }
        AddonUtil.playerStatus.remove(event.previousSession().getUniqueId());
        this.addon.addonUtil().ranking(0);
        this.addon.addonUtil().breakGoalBlocks(0);
        this.addon.addonUtil().pickaxeRanking(0);
        this.addon.addonUtil().swordRanking(0);
    }

    @Subscribe
    public void onProfileChange(ProfileSwitchEvent event) {
        if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).resetOnProfileSwitch().get()).booleanValue()) {
            this.addon.addonUtil().resetValues(false);
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.dataReset.profile.title", (TextColor)NamedTextColor.AQUA), (Component)Component.translatable((String)"moneymaker.notification.dataReset.profile.text", (TextColor)NamedTextColor.YELLOW));
        }
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        if (this.addon.moneyChatClient().isAuthenticated()) {
            this.addon.moneyChatClient().sendPacket(new PacketAddonStatistics("remove", Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), "", "", false));
            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), "OFFLINE", MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
            this.addon.moneyChatClient().sendPacket(new PacketLeaderboard(this.addon.labyAPI().getUniqueId(), this.addon.labyAPI().getName(), this.addon));
        }
        this.addon.moneyChatClient().disconnect(MoneyChatClient.Initiator.SERVER, "Game Shutdown", "Game Shutdown");
        if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).exportBoosterOnShutdown().get()).booleanValue()) {
            BoosterActivity.writeLinkedListToCSV(true);
        }
    }

    @Subscribe
    public void onMineSwitch(MineSwitchEvent event) {
        if (this.lastMineUpdate + 10000L - System.currentTimeMillis() <= 0L) {
            this.lastMineUpdate = System.currentTimeMillis();
            if (this.addon.moneyChatClient().isAuthenticated()) {
                this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
            }
            if (event.getNewMine() != null) {
                this.addon.sendServerUpdate("MoneyMaker \u00bb " + I18n.translate((String)event.getNewMine().translation(), (Object[])new Object[0]));
            }
        }
    }

    @Subscribe
    public void onCaveLevelChange(CaveLevelChangeEvent event) {
        if (this.lastCave == event.newCave()) {
            return;
        }
        this.lastCave = event.newCave();
        this.addon.addonUtil().farmingCave(event.newCave());
        if (this.lastLevelUpdate + 10000L - System.currentTimeMillis() <= 0L) {
            this.lastLevelUpdate = System.currentTimeMillis();
            if (this.addon.moneyChatClient().isAuthenticated()) {
                this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
            }
            this.addon.sendServerUpdate("MoneyMaker \u00bb " + I18n.translate((String)event.newCave().translation(), (Object[])new Object[0]));
        }
    }

    @Subscribe
    public void onMoneyChatDisconnect(MoneyChatDisconnectEvent event) {
        AddonUtil.playerStatus.clear();
        if (event.getInitiator() != MoneyChatClient.Initiator.USER && !((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideChatConnectionNotifications().get()).booleanValue()) {
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.chat.disconnect", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)event.getReason())}));
        }
    }

    @Subscribe
    public void onPlayerStatusUpdate(MoneyPlayerStatusEvent event) {
        UUID uuid = event.uuid();
        MoneyPlayer player = event.player();
        if (uuid.equals(this.addon.labyAPI().getUniqueId())) {
            this.addon.addonUtil().group(player.group());
        }
        if (AddonUtil.playerStatus.containsKey(uuid)) {
            String serverBefore = AddonUtil.playerStatus.get(uuid).server();
            if (AddonUtil.playerStatus.get(uuid).hideOnlineStatus() != player.hideOnlineStatus()) {
                this.addon.chatActivity().reloadScreen();
            }
            if (serverBefore.equalsIgnoreCase("Other") && (player.server().equalsIgnoreCase("Mine") || player.server().startsWith("Farming")) && this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.labyAPI().getUniqueId().toString().equals(uuid.toString()) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.onlineOfflineMessages().get()).booleanValue()) {
                if (((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.onlineOfflineNotifications().get() == MoneyChatConfiguration.NotificationType.LABYMOD) {
                    Task.builder(() -> this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.chat.user.online", (TextColor)TextColor.color((int)85, (int)255, (int)85), (Component[])new Component[]{Component.text((String)(player.group().getChatPrefix() + player.userName()))}), Icon.head((UUID)uuid))).delay(2L, TimeUnit.SECONDS).build().execute();
                } else {
                    this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.notification.chat.user.online", (TextColor)TextColor.color((int)85, (int)255, (int)85), (Component[])new Component[]{Component.text((String)(player.group().getChatPrefix() + player.userName()))})));
                }
            }
            if ((serverBefore.equalsIgnoreCase("Mine") || serverBefore.startsWith("Farming")) && (player.server().equalsIgnoreCase("Other") || player.server().equals("OFFLINE")) && this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.labyAPI().getUniqueId().toString().equals(uuid.toString()) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.onlineOfflineMessages().get()).booleanValue()) {
                if (((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.onlineOfflineNotifications().get() == MoneyChatConfiguration.NotificationType.LABYMOD) {
                    this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.chat.user.offline", (TextColor)TextColor.color((int)255, (int)85, (int)85), (Component[])new Component[]{Component.text((String)(player.group().getChatPrefix() + player.userName()))}), Icon.head((UUID)uuid));
                } else {
                    this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.notification.chat.user.offline", (TextColor)TextColor.color((int)255, (int)85, (int)85), (Component[])new Component[]{Component.text((String)(player.group().getChatPrefix() + player.userName()))})));
                }
            }
        }
        AddonUtil.playerStatus.put(uuid, player);
        if (player.server().equals("OFFLINE")) {
            AddonUtil.playerStatus.remove(uuid);
        }
    }

    @Subscribe
    public void onMoneyChatReceive(MoneyChatReceiveEvent event) {
        MoneyChatMessage chatMessage = event.chatMessage();
        this.addon.chatActivity().addChatMessage(chatMessage);
        if (!this.addon.addonUtil().connectedToMoneyMaker()) {
            return;
        }
        if (chatMessage.fromServerCache()) {
            return;
        }
        if (!chatMessage.uuid().equals(this.addon.labyAPI().getUniqueId())) {
            if (chatMessage.messageType() != MoneyChatMessage.MessageType.SERVER) {
                if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.notification().get()).booleanValue()) {
                    this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.new-message", (TextColor)TextColor.color((int)85, (int)255, (int)85)), ((TextComponent)Component.text((String)chatMessage.userName(), (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)chatMessage.message(), (TextColor)NamedTextColor.GRAY)), Icon.head((UUID)chatMessage.uuid()), (Component)Component.translatable((String)"moneymaker.notification.chat.reply", (Component[])new Component[0]), () -> this.addon.mainActivity().openAndSwitchToChat());
                    if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.notificationSound().get()).booleanValue()) {
                        this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_CHAT_MESSAGE, 0.35f, 1.0f);
                    }
                }
            } else {
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.system-message", (TextColor)TextColor.color((int)255, (int)85, (int)85)), (Component)Component.text((String)chatMessage.message(), (TextColor)NamedTextColor.RED), Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)1, (int)2));
                this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.35f, 1.0f);
            }
        }
    }
}

