/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat.session;

import java.util.UUID;
import net.labymod.api.client.session.Session;
import net.labymod.api.util.UUIDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoneySession
implements Session {
    private final String username;
    private final UUID uniqueId;
    private final boolean hasUniqueId;
    private final String accessToken;
    private final Session.Type type;
    private final boolean premium;

    public MoneySession(String username, UUID uniqueId, String accessToken, Session.Type type) {
        this.username = username;
        this.uniqueId = uniqueId == null ? UUIDHelper.createUniqueId((String)username) : uniqueId;
        this.hasUniqueId = uniqueId != null;
        this.accessToken = accessToken;
        this.type = type;
        this.premium = this.isPremium(accessToken);
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean hasUniqueId() {
        return this.hasUniqueId;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public Session.Type getType() {
        return this.type;
    }

    public boolean isPremium() {
        return this.premium;
    }

    private boolean isPremium(String accessToken) {
        return accessToken != null && accessToken.length() > 10;
    }
}

