/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.util.GsonUtil;
import net.labymod.api.util.StringUtil;
import net.labymod.api.util.logging.Logging;

public class ChatMessageLoader {
    private final Logging logging = Logging.create((String)"MM-ChatMessageLoader");
    public HashMap<String, String> availableLanguages = new HashMap();
    private final Map<String, String> messages = new HashMap<String, String>();
    private static String selectedLanguage;

    public String message(String key) {
        return this.messages.getOrDefault(key, key);
    }

    public void loadMessages(String namespace, String selectedLanguage) throws IOException {
        this.loadMessages(namespace, selectedLanguage, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMessages(String namespace, String selectedLanguage, Map<String, String> target) throws IOException {
        block19: {
            selectedLanguage = selectedLanguage.toLowerCase(Locale.ENGLISH);
            if (ChatMessageLoader.selectedLanguage == null || !ChatMessageLoader.selectedLanguage.equals(selectedLanguage)) {
                this.messages.clear();
                ChatMessageLoader.selectedLanguage = selectedLanguage;
            }
            if (this.existsMessageDirectory(namespace)) {
                String name = String.format(Locale.ROOT, "assets/%s/chat_messages/%s", namespace, StringUtil.toLowercase((String)selectedLanguage) + ".json");
                ResourceLocation location = ResourceLocation.create((String)namespace, (String)("chat_messages/" + StringUtil.toLowercase((String)selectedLanguage) + ".json"));
                InputStream inputStream = null;
                try {
                    inputStream = location.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (inputStream != null) {
                    try {
                        block20: {
                            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                                JsonElement element;
                                try {
                                    element = (JsonElement)GsonUtil.DEFAULT_GSON.fromJson((Reader)reader, JsonElement.class);
                                }
                                catch (JsonSyntaxException exception) {
                                    this.logging.error((CharSequence)"Could not load the translations of {}.", new Object[]{namespace, exception});
                                    break block19;
                                }
                                if (!element.isJsonObject()) {
                                    this.logging.error((CharSequence)"Invalid language file: \"{}:{}\"", new Object[]{namespace, name});
                                    break block20;
                                }
                                JsonObject object = element.getAsJsonObject();
                                for (Map.Entry entry : object.entrySet()) {
                                    this.readJsonTree(target, (String)entry.getKey(), (JsonElement)entry.getValue());
                                }
                            }
                            return;
                        }
                        return;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
        }
    }

    private boolean existsMessageDirectory(String namespace) {
        try {
            InputStream inputStream = ChatMessageLoader.getResourceAsInputStream("assets/" + namespace + "/chat_messages/");
            inputStream.close();
            return true;
        }
        catch (IOException var3) {
            return false;
        }
    }

    private void readJsonTree(Map<String, String> target, String key, JsonElement element) {
        if (!element.isJsonObject()) {
            if (element.isJsonPrimitive()) {
                target.putIfAbsent(key, element.getAsString());
            }
        } else {
            JsonObject object = element.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                this.readJsonTree(target, key + "." + (String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
    }

    public static InputStream getResourceAsInputStream(String path) throws IOException {
        URL resource = MoneyMakerAddon.class.getClassLoader().getResource(path);
        if (resource == null) {
            throw new FileNotFoundException("No resource was found at this location: (" + path + ")");
        }
        return resource.openStream();
    }
}

