/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.widgets.TimerWidget;
import de.timuuuu.moneymaker.utils.MoneyTimer;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.Constants;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@AutoActivity
@Links(value={@Link(value="start.lss"), @Link(value="buttons.lss")})
public class StartActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private AtomicInteger secretCount = new AtomicInteger(5);

    public StartActivity(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.start.title").addId("title");
        ((Document)this.document).addChild((Widget)titleWidget);
        DivWidget container = new DivWidget();
        container.addId("start-container");
        ComponentWidget breakGoalTitle = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.start.break-goal.title").addId("break-goal-title");
        breakGoalTitle.setHoverComponent((Component)Component.translatable((String)"moneymaker.ui.start.break-goal.description", (Component[])new Component[0]));
        container.addChild((Widget)breakGoalTitle);
        SwitchWidget breakGoalSwitch = (SwitchWidget)SwitchWidget.create(value -> {
            this.addon.addonSettings().breakGoalEnabled(value);
            this.addon.addonUtil().breakGoalBlocks(0);
            if (!value) {
                this.addon.addonSettings().breakGoal(0);
            }
            this.reload();
        }).addId("break-goal-switch");
        breakGoalSwitch.setValue(this.addon.addonSettings().breakGoalEnabled());
        breakGoalSwitch.setHoverComponent((Component)Component.translatable((String)"moneymaker.ui.start.break-goal.description", (Component[])new Component[0]));
        container.addChild((Widget)breakGoalSwitch);
        if (this.addon.addonSettings().breakGoalEnabled()) {
            ComponentWidget breakGoalInputTitle = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.start.break-goal.input-title").addId("break-goal-input-title");
            breakGoalInputTitle.setHoverComponent((Component)Component.translatable((String)"moneymaker.ui.start.break-goal.input-description", (Component[])new Component[0]));
            container.addChild((Widget)breakGoalInputTitle);
            TextFieldWidget breakGoalInput = (TextFieldWidget)new TextFieldWidget().addId("break-goal-input");
            breakGoalInput.submitHandler(this::submitInput);
            if (this.addon.addonSettings().breakGoal() > 0) {
                breakGoalInput.setText(String.valueOf(this.addon.addonSettings().breakGoal()));
            }
            container.addChild((Widget)breakGoalInput);
        }
        DivWidget commandsContainer = (DivWidget)new DivWidget().addId("commands-container");
        commandsContainer.addChild(ComponentWidget.i18n((String)"moneymaker.ui.start.commands.title").addId("commands-title"));
        Component commands = ((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"moneymaker.ui.start.commands.timer.command", (TextColor)NamedTextColor.AQUA).append((Component)Component.translatable((String)"moneymaker.ui.start.commands.timer.description", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.ui.start.commands.reset.command", (TextColor)NamedTextColor.AQUA))).append((Component)Component.translatable((String)"moneymaker.ui.start.commands.reset.description", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.ui.start.commands.verify.command", (TextColor)NamedTextColor.AQUA))).append((Component)Component.translatable((String)"moneymaker.ui.start.commands.verify.description", (TextColor)NamedTextColor.GOLD));
        commandsContainer.addChild(ComponentWidget.component((Component)commands).addId("command-list"));
        DivWidget timerContainer = (DivWidget)new DivWidget().addId("timer-container");
        timerContainer.addChild(ComponentWidget.i18n((String)"moneymaker.ui.start.current-timers").addId("timer-title"));
        VerticalListWidget timerList = (VerticalListWidget)new VerticalListWidget().addId("timer-list");
        Util.timers.values().forEach(timer -> timerList.addChild((Widget)new TimerWidget(this.addon, (MoneyTimer)timer)));
        timerContainer.addChild(new ScrollWidget((Widget)timerList, new ListSession()).addId("timer-scroll"));
        ((Document)this.document).addChild((Widget)container);
        ((Document)this.document).addChild((Widget)commandsContainer);
        ((Document)this.document).addChild((Widget)timerContainer);
        ButtonWidget secretButton = (ButtonWidget)ButtonWidget.text((String)"").addId("secret-button");
        secretButton.setActionListener(() -> {
            this.secretCount.decrementAndGet();
            if (this.secretCount.get() == 0) {
                this.addon.mainActivity().registerSecret();
                this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.35f, 1.0f);
            }
        });
        ((Document)this.document).addChild((Widget)secretButton);
        ((Document)this.document).addChild((Widget)Util.feedbackButton());
        ((Document)this.document).addChild((Widget)Util.discordButton());
        ((Document)this.document).addChild((Widget)Util.leaderboardButton());
        Util.addCredits(this.addon, (Document)this.document);
    }

    private void submitInput(String input) {
        try {
            int count = Util.parseInteger(input, ((Object)((Object)this)).getClass());
            this.addon.addonSettings().breakGoal(count);
            if (this.addon.addonUtil().currentBrokenBlocks() > 0) {
                this.addon.addonUtil().breakGoalBlocks(this.addon.addonUtil().currentBrokenBlocks() + count);
            }
            this.addon.addonUtil().startTimestamp(System.currentTimeMillis());
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.break-goal.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.break-goal.set", (TextColor)TextColor.color((int)170, (int)170, (int)170), (Component[])new Component[]{Component.text((String)Util.format(count), (TextColor)TextColor.color((int)255, (int)255, (int)85))}));
        }
        catch (NumberFormatException ignored) {
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.break-goal.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.break-goal.no-number", (TextColor)TextColor.color((int)255, (int)85, (int)85)));
        }
    }

    public void reloadScreen() {
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> ((StartActivity)this).reload());
    }
}

