/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.popup;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import java.util.function.Consumer;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.types.GsonRequest;

@Link(value="popup/chat-rules.lss")
@AutoActivity
public class ChatRulesActivity
extends SimpleActivity {
    public static JsonObject CACHED_RULES;
    private static String CACHED_LANGUAGE;
    private MoneyMakerAddon addon;
    private ScreenInstance previousScreen;
    private boolean updateConfiguration;
    private JsonObject rules;

    public ChatRulesActivity(MoneyMakerAddon addon, ScreenInstance previousScreen, boolean updateConfiguration, JsonObject rules) {
        this.addon = addon;
        this.previousScreen = previousScreen;
        this.updateConfiguration = updateConfiguration;
        this.rules = rules;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.chat-rules.title").addId("title");
        header.addEntry((Widget)titleWidget);
        if (!this.updateConfiguration) {
            IconWidget closeButton = (IconWidget)new IconWidget(Textures.SpriteCommon.SMALL_X_WITH_SHADOW).addId("close-button");
            closeButton.setPressable(() -> this.closeScreen(false));
            header.addEntry((Widget)closeButton);
        }
        container.addContent((Widget)header);
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
        try {
            if (this.rules.has("header")) {
                content.addChild((Widget)((ComponentWidget)ComponentWidget.text((String)this.rules.get("header").getAsString()).addId("note")));
            }
            if (this.rules.has("rules")) {
                for (JsonElement element : this.rules.get("rules").getAsJsonArray()) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject rule = element.getAsJsonObject();
                    if (rule.has("title")) {
                        content.addChild((Widget)((ComponentWidget)ComponentWidget.text((String)rule.get("title").getAsString()).addId("title")));
                    }
                    if (!rule.has("text")) continue;
                    content.addChild((Widget)((ComponentWidget)ComponentWidget.text((String)rule.get("text").getAsString()).addId("text")));
                }
            }
            if (this.rules.has("footer")) {
                content.addChild((Widget)((ComponentWidget)ComponentWidget.text((String)this.rules.get("footer").getAsString()).addId("note")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ComponentWidget errorWidget = (ComponentWidget)ComponentWidget.text((String)exception.getMessage()).addId("note");
            content.addChild((Widget)errorWidget);
        }
        container.addFlexibleContent(new ScrollWidget(content).addId("scroll"));
        HorizontalListWidget footer = (HorizontalListWidget)new HorizontalListWidget().addId("footer");
        if (this.rules != null && this.rules.has("version") && this.rules.has("versiondate")) {
            ComponentWidget versionComponent = ComponentWidget.component((Component)((TranslatableComponent)Component.translatable((String)"moneymaker.chat-rules.version.name", (Component[])new Component[0]).append((Component)Component.text((String)this.rules.get("version").getAsString()))).append(((TextComponent)Component.text((String)" | ").append((Component)Component.translatable((String)"moneymaker.chat-rules.version.date", (Component[])new Component[0]))).append((Component)Component.text((String)this.rules.get("versiondate").getAsString()))));
            versionComponent.addId("version-info");
            footer.addEntry((Widget)versionComponent);
        }
        if (this.updateConfiguration) {
            ButtonWidget acceptButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.chat-rules.accept").addId("accept-button");
            acceptButton.setPressable(() -> this.closeScreen(true));
            footer.addEntry((Widget)acceptButton);
        }
        container.addContent((Widget)footer);
        ((Document)this.document).addChild((Widget)container);
    }

    private void closeScreen(boolean accepted) {
        if (accepted && this.updateConfiguration && this.rules.has("version")) {
            ((MoneyMakerConfiguration)this.addon.configuration()).chatRulesVersion().set((Object)this.rules.get("version").getAsInt());
            this.addon.saveConfiguration();
        }
        this.addon.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen);
    }

    public static void create(MoneyMakerAddon addon, ScreenInstance previousScreen, boolean updateConfiguration, Consumer<ChatRulesActivity> callback) {
        if (CACHED_RULES != null && CACHED_LANGUAGE != null && CACHED_LANGUAGE.equals(addon.labyAPI().minecraft().options().getCurrentLanguage())) {
            addon.labyAPI().minecraft().executeNextTick(() -> callback.accept(new ChatRulesActivity(addon, previousScreen, updateConfiguration, CACHED_RULES)));
            return;
        }
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url("https://api.moneymakeraddon.de/chat/rules?lang=" + addon.labyAPI().minecraft().options().getCurrentLanguage(), new Object[0])).async()).connectTimeout(5000)).readTimeout(5000)).execute(response -> {
            if (response.getStatusCode() != 200 || response.hasException()) {
                callback.accept(null);
                return;
            }
            addon.labyAPI().minecraft().executeNextTick(() -> callback.accept(new ChatRulesActivity(addon, previousScreen, updateConfiguration, (JsonObject)response.get())));
            CACHED_RULES = (JsonObject)response.get();
            CACHED_LANGUAGE = addon.labyAPI().minecraft().options().getCurrentLanguage();
        });
    }

    public JsonObject rules() {
        return this.rules;
    }
}

