/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.popup;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.models.OperatingSystem;

@Link(value="popup/token-verification.lss")
@AutoActivity
public class TokenVerificationActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private TokenType tokenType = null;
    private String token = null;
    private boolean error = false;
    private String errorMessage = "";

    public TokenVerificationActivity(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void onCloseScreen() {
    }

    public boolean keyPressed(Key key, InputType type) {
        if (key == Key.ESCAPE) {
            this.closeScreen();
            this.resetCachedData();
            return true;
        }
        return super.keyPressed(key, type);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.verification.title").addId("title");
        header.addEntry((Widget)titleWidget);
        IconWidget closeButton = (IconWidget)new IconWidget(Textures.SpriteCommon.SMALL_X_WITH_SHADOW).addId("close-button");
        closeButton.setPressable(() -> {
            this.closeScreen();
            this.resetCachedData();
        });
        header.addEntry((Widget)closeButton);
        container.addContent((Widget)header);
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
        if (this.tokenType != null && this.token != null) {
            content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.tokenGenerated").addId("info-token-text"));
            content.addChild(ComponentWidget.component((Component)Component.translatable((String)"moneymaker.verification.activity.token", (Component[])new Component[]{Component.text((String)this.token, (TextColor)NamedTextColor.YELLOW)})).addId("info-token"));
            if (this.tokenType == TokenType.WEBSITE) {
                content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.website.infoText").addId("info-website-text"));
                ButtonWidget websiteButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.verification.activity.website.openButton").addId("website-button");
                websiteButton.setPressable(() -> OperatingSystem.getPlatform().openUri("https://moneymakeraddon.de/register?token=" + this.token));
                content.addChild((Widget)websiteButton);
            }
            if (this.tokenType == TokenType.DISCORD) {
                container.addId("discord-container");
                ButtonWidget copyCodeButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.verification.activity.discord.copyToken").addId("copy-token-button");
                copyCodeButton.setPressable(() -> {
                    this.addon.labyAPI().minecraft().setClipboard(this.token);
                    this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.verification.title", (TextColor)NamedTextColor.GREEN), (Component)Component.translatable((String)"moneymaker.verification.activity.discord.copied", (TextColor)NamedTextColor.GRAY));
                });
                content.addChild((Widget)copyCodeButton);
                content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.discord.infoText1").addId("info-discord-text-1"));
                content.addChild(ComponentWidget.component((Component)Component.translatable((String)"moneymaker.verification.activity.discord.infoText2", (Component[])new Component[]{Component.text((String)"#account-verification", (TextColor)NamedTextColor.YELLOW)})).addId("info-discord-text-2"));
                ButtonWidget discordInviteButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.verification.activity.discordButton").addId("discord-invite-button");
                discordInviteButton.setPressable(() -> OperatingSystem.getPlatform().openUri("https://discord.moneymakeraddon.de/"));
                content.addChild((Widget)discordInviteButton);
            }
        } else if (this.error) {
            content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.error").addId("info-server-response"));
            content.addChild(ComponentWidget.component((Component)Component.translatable((String)"moneymaker.verification.activity.errorReason", (Component[])new Component[]{Component.text((String)this.errorMessage, (TextColor)NamedTextColor.RED)})).addId("info-server-wait"));
            discordInviteButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.verification.activity.discordButton").addId("discord-invite-button");
            discordInviteButton.setPressable(() -> OperatingSystem.getPlatform().openUri("https://discord.moneymakeraddon.de/"));
            content.addChild((Widget)discordInviteButton);
        } else {
            content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.serverWaiting").addId("info-server-response"));
            content.addChild(ComponentWidget.i18n((String)"moneymaker.verification.activity.serverResponseInfo").addId("info-server-wait"));
            discordInviteButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.verification.activity.discordButton").addId("discord-invite-button");
            discordInviteButton.setPressable(() -> OperatingSystem.getPlatform().openUri("https://discord.moneymakeraddon.de/"));
            content.addChild((Widget)discordInviteButton);
        }
        container.addFlexibleContent((Widget)content);
        HorizontalListWidget footer = (HorizontalListWidget)new HorizontalListWidget().addId("footer");
        footer.addEntry(ComponentWidget.i18n((String)"moneymaker.verification.activity.closeInfo").addId("window-close-info"));
        container.addContent((Widget)footer);
        ((Document)this.document).addChild((Widget)container);
    }

    public void setToken(TokenType tokenType, String token) {
        this.tokenType = tokenType;
        this.token = token;
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> ((TokenVerificationActivity)this).reload());
    }

    public void setError(String errorMessage) {
        this.error = true;
        this.errorMessage = errorMessage;
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> ((TokenVerificationActivity)this).reload());
    }

    public void resetCachedData() {
        this.tokenType = null;
        this.token = null;
        this.error = false;
        this.errorMessage = "";
    }

    public static enum TokenType {
        WEBSITE("website"),
        DISCORD("discord");

        private final String name;

        private TokenType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static TokenType fromName(String name) {
            for (TokenType type : TokenType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

