/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.group;

import java.awt.Color;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;

public class Group {
    private int id;
    private String name;
    private String displayName;
    private String colorHex;
    private String minecraftColor;
    private String tagName;
    private String displayTypeName;
    private String iconName;
    private Icon icon;
    private String iconUrl;
    private boolean isAdmin;
    private boolean isStaff;
    private transient GroupDisplay displayType;
    private transient Color color = Color.WHITE;
    private transient TextColor textColor = NamedTextColor.WHITE;
    private transient String chatPrefix;

    public Group(int id, String name, String displayName, String colorHex, String minecraftColor, String tagName, String displayTypeName, String iconName, String iconUrl, boolean isAdmin, boolean isStaff) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.colorHex = colorHex;
        this.minecraftColor = minecraftColor;
        this.tagName = tagName;
        this.displayTypeName = displayTypeName;
        this.iconName = iconName;
        this.iconUrl = iconUrl;
        this.isAdmin = isAdmin;
        this.isStaff = isStaff;
    }

    public Group initialize() {
        ResourceLocation iconLocation;
        GroupDisplay displayType;
        this.displayType = this.displayTypeName != null ? ((displayType = GroupDisplay.getDisplay(this.displayTypeName)) == null ? GroupDisplay.NONE : displayType) : GroupDisplay.NONE;
        if (this.iconName != null && (iconLocation = ResourceLocation.create((String)"moneymaker", (String)("textures/" + this.iconName + ".png"))).exists()) {
            this.icon = Icon.texture((ResourceLocation)iconLocation);
        }
        try {
            if (this.colorHex != null && !this.colorHex.isEmpty()) {
                this.color = Color.decode("#" + this.colorHex);
                this.textColor = TextColor.color((int)this.color.getRGB());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chatPrefix = this.displayName != null ? "\u00a78[" + this.minecraftColor + this.displayName + "\u00a78] " + this.minecraftColor : this.minecraftColor;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getColorHex() {
        return this.colorHex;
    }

    public String getMinecraftColor() {
        return this.minecraftColor;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isStaff() {
        return this.isStaff;
    }

    public GroupDisplay getDisplayType() {
        return this.displayType;
    }

    public Color getColor() {
        return this.color;
    }

    public TextColor getTextColor() {
        return this.textColor;
    }

    public String getChatPrefix() {
        return this.chatPrefix;
    }

    public static enum GroupDisplay {
        NONE,
        BESIDE_NAME,
        ABOVE_HEAD,
        BOTH;


        public static GroupDisplay getDisplay(String name) {
            for (GroupDisplay value : GroupDisplay.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

