/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget.farming;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.Util;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;

@SpriteSlot(x=1)
public class PickaxeStatsWidget
extends TextHudWidget<PickaxeHudWidgetConfig> {
    private MoneyMakerAddon addon;
    private TextLine rankLine;
    private TextLine chanceLine;
    DecimalFormat decimalFormat = new DecimalFormat("#.####");

    public PickaxeStatsWidget(MoneyMakerAddon addon) {
        super("mm_pickaxe_stats", PickaxeHudWidgetConfig.class);
        this.addon = addon;
        this.bindCategory(MoneyMakerAddon.CATEGORY);
        this.decimalFormat.setRoundingMode(RoundingMode.CEILING);
    }

    public void load(PickaxeHudWidgetConfig config) {
        super.load((TextHudWidgetConfig)config);
        this.rankLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_pickaxe_stats.display.rank", (Component[])new Component[0]), "0");
        this.chanceLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_pickaxe_stats.display.chance", (Component[])new Component[0]), "0");
        this.updateLines();
    }

    public void onTick(boolean isEditorContext) {
        this.updateLines();
    }

    private void updateLines() {
        Object additional = "";
        if (((Boolean)((PickaxeHudWidgetConfig)this.getConfig()).showRankingDifference().get()).booleanValue() && this.addon.addonUtil().savedPickaxeRanking() != 0) {
            int diff = this.addon.addonUtil().savedPickaxeRanking() - this.addon.addonUtil().pickaxeRanking();
            additional = " (" + (diff == 0 ? "" : (diff > 0 ? "\u2191 " : "\u2193 ")) + diff + ")";
        }
        String pickaxeRanking = this.addon.addonUtil().savedPickaxeRanking() != 0 ? Util.format(this.addon.addonUtil().pickaxeRanking()) : this.addon.addonUtil().savedPickaxeRankingString();
        this.rankLine.updateAndFlush((Object)(pickaxeRanking + (String)additional));
        this.rankLine.setState(!(!this.addon.addonUtil().inFarming() && (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() == false || this.addon.addonUtil().pickaxeRanking() == 0 && this.addon.addonUtil().savedPickaxeRankingString().isEmpty()) ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
        Object averageChance = "";
        if (((Boolean)((PickaxeHudWidgetConfig)this.getConfig()).showAverageChance().get()).booleanValue() && Booster.sessionBoosters.get() > 0 && this.addon.addonUtil().sessionBlocks() > 0) {
            float change = (float)Booster.sessionBoosters.get() / (float)this.addon.addonUtil().sessionBlocks() * 100.0f;
            averageChance = " (" + this.decimalFormat.format(change) + " %)";
        }
        this.chanceLine.updateAndFlush((Object)(this.addon.addonUtil().pickaxeBoosterChance() + (String)averageChance));
        this.chanceLine.setState((this.addon.addonUtil().inFarming() || (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() != false) && !this.addon.addonUtil().pickaxeBoosterChance().isEmpty() ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
    }

    public static class PickaxeHudWidgetConfig
    extends TextHudWidgetConfig {
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showRankingDifference = new ConfigProperty((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showAverageChance = new ConfigProperty((Object)true);

        public ConfigProperty<Boolean> showRankingDifference() {
            return this.showRankingDifference;
        }

        public ConfigProperty<Boolean> showAverageChance() {
            return this.showAverageChance;
        }
    }
}

