/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat.pipeline;

import de.timuuuu.moneymaker.moneychat.MoneyChatClient;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacket;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacketBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.labymod.api.util.logging.Logging;

public class PacketDecoder
extends ByteToMessageDecoder {
    private final Logging LOGGER = Logging.getLogger();
    private final MoneyChatClient moneyChatClient;

    public PacketDecoder(MoneyChatClient moneyChatClient) {
        this.moneyChatClient = moneyChatClient;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() >= 1) {
            MoneyPacketBuffer packetBuffer = new MoneyPacketBuffer(byteBuf);
            int id = packetBuffer.readVarIntFromBuffer();
            MoneyPacket packet = this.moneyChatClient.protocol().getPacket(id);
            if (id != 14 && id != 15) {
                this.LOGGER.debug((CharSequence)("[MoneyChatClient] [IN] " + id + " " + packet.getClass().getSimpleName()), new Object[0]);
            }
            packet.read(packetBuffer);
            if (byteBuf.readableBytes() > 0) {
                String simpleName = packet.getClass().getSimpleName();
                throw new IOException("Packet " + simpleName + " was larger than I expected, found " + byteBuf.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(packet));
            }
            list.add(packet);
        }
    }
}

