/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat.protocol;

import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacket;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketAddonMessage;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketDisconnect;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketPing;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketPong;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketAddonStatistics;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketClearChat;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketLeaderboard;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessage;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessageDelete;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketReport;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserMute;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserRankUpdate;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserUnmute;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketVerificationToken;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketEncryptionRequest;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketEncryptionResponse;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketLogin;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketLoginComplete;
import java.util.HashMap;
import java.util.Map;
import net.labymod.api.util.logging.Logging;

public class MoneyChatProtocol {
    private final Logging LOGGER = Logging.getLogger();
    private final Map<Integer, Class<? extends MoneyPacket>> packets = new HashMap<Integer, Class<? extends MoneyPacket>>();

    public MoneyChatProtocol() {
        this.register(0, MoneyPacketLogin.class);
        this.register(1, MoneyPacketEncryptionRequest.class);
        this.register(2, MoneyPacketEncryptionResponse.class);
        this.register(3, MoneyPacketLoginComplete.class);
        this.register(4, PacketMessage.class);
        this.register(5, PacketMessageDelete.class);
        this.register(6, PacketClearChat.class);
        this.register(7, PacketPlayerStatus.class);
        this.register(8, PacketReport.class);
        this.register(9, PacketUserMute.class);
        this.register(10, PacketUserUnmute.class);
        this.register(11, PacketUserRankUpdate.class);
        this.register(12, PacketAddonStatistics.class);
        this.register(13, MoneyPacketDisconnect.class);
        this.register(14, MoneyPacketPing.class);
        this.register(15, MoneyPacketPong.class);
        this.register(16, PacketLeaderboard.class);
        this.register(20, MoneyPacketAddonMessage.class);
        this.register(30, PacketVerificationToken.class);
    }

    private void register(int id, Class<? extends MoneyPacket> clazz) {
        try {
            this.LOGGER.debug((CharSequence)"Registering packet {} as id {}", new Object[]{clazz.getName(), id});
            this.packets.put(id, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MoneyPacket getPacket(int id) throws Exception {
        if (!this.packets.containsKey(id)) {
            throw new RuntimeException("Packet with id " + id + " is not registered.");
        }
        return this.packets.get(id).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public int getPacketId(MoneyPacket packet) {
        for (Map.Entry<Integer, Class<? extends MoneyPacket>> entry : this.packets.entrySet()) {
            Class<? extends MoneyPacket> value = entry.getValue();
            if (!value.isInstance(packet)) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Packet " + String.valueOf(packet) + " is not registered.");
    }
}

