/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.utils.MoneyPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.labymod.api.util.I18n;

public class AddonUtil {
    private MoneyMakerAddon addon;
    private MoneyMakerEvent currentEvent = MoneyMakerEvent.NONE;
    private MoneyMakerJoinMessage joinMessage = null;
    private List<String> ignoredRankingValues = new ArrayList<String>();
    public static HashMap<UUID, MoneyPlayer> playerStatus = new HashMap();
    private Group group;
    private boolean inMine = false;
    private boolean inFarming = false;
    private FarmingCave farmingCave = FarmingCave.UNKNOWN;
    private MineType currentMine = null;
    private boolean leaderboardShowBlocks = true;
    private String balance = "X";
    private int ranking = 0;
    private int pickaxeLevel = 0;
    private int pickaxeRanking = 0;
    private int savedPickaxeRanking = 0;
    private String savedPickaxeRankingString = "";
    private String pickaxeBoosterChance = "";
    private int brokenBlocks = 0;
    private int sessionBlocks = 0;
    private int currentBrokenBlocks = 0;
    private int breakGoalBlocks = 0;
    private int workerCount = 0;
    private String nextWorkerCost = "X";
    private String debrisCost = "X";
    private int savedSwordRanking = 0;
    private int swordRanking = 0;
    private int swordMobs = 0;
    private int mobKills = 0;
    private int sessionKills = 0;
    private int debrisTime = 0;
    private long startTimestamp = 0L;
    private boolean workerNotifySent = false;
    private boolean debrisNotifySent = false;

    public AddonUtil(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public MoneyMakerEvent currentEvent() {
        return this.currentEvent;
    }

    public void currentEvent(MoneyMakerEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    public MoneyMakerJoinMessage getJoinMessage() {
        return this.joinMessage;
    }

    public void setJoinMessage(MoneyMakerJoinMessage joinMessage) {
        this.joinMessage = joinMessage;
    }

    public List<String> ignoredRankingValues() {
        return this.ignoredRankingValues;
    }

    public void resetValues(boolean changePlaying) {
        if (changePlaying) {
            this.inMine = false;
            this.inFarming = false;
        }
        this.balance = "X";
        this.ranking = 0;
        this.pickaxeLevel = 0;
        this.pickaxeRanking = 0;
        this.savedPickaxeRanking = 0;
        this.savedPickaxeRankingString = "";
        this.pickaxeBoosterChance = "";
        this.brokenBlocks = 0;
        this.sessionBlocks = 0;
        this.addon.addonSettings().breakGoalEnabled(false);
        this.addon.addonSettings().breakGoal(0);
        this.breakGoalBlocks = 0;
        this.workerCount = 0;
        this.nextWorkerCost = "X";
        this.debrisCost = "X";
        this.debrisNotifySent = false;
        this.workerNotifySent = false;
        this.savedSwordRanking = 0;
        this.swordRanking = 0;
        this.swordMobs = 0;
        this.mobKills = 0;
        this.sessionKills = 0;
        this.addon.entityRenderListener().stopDebrisTask();
        this.currentMine = null;
    }

    public Group group() {
        return this.group;
    }

    public void group(Group group) {
        this.group = group;
    }

    public FarmingCave farmingCave() {
        return this.farmingCave;
    }

    public void farmingCave(FarmingCave farmingCave) {
        this.farmingCave = farmingCave;
    }

    public MineType currentMine() {
        return this.currentMine;
    }

    public void currentMine(MineType currentMine) {
        this.currentMine = currentMine;
    }

    public boolean connectedToMoneyMaker() {
        return this.inMine || this.inFarming;
    }

    public boolean inMine() {
        return this.inMine;
    }

    public void inMine(boolean inMine) {
        this.inMine = inMine;
    }

    public boolean inFarming() {
        return this.inFarming;
    }

    public void inFarming(boolean inFarming) {
        this.inFarming = inFarming;
    }

    public boolean leaderboardShowBlocks() {
        return this.leaderboardShowBlocks;
    }

    public void leaderboardShowBlocks(boolean leaderboardShowBlocks) {
        this.leaderboardShowBlocks = leaderboardShowBlocks;
    }

    public String balance() {
        return this.balance;
    }

    public void balance(String balance) {
        this.balance = balance;
    }

    public int ranking() {
        return this.ranking;
    }

    public void ranking(int ranking) {
        this.ranking = ranking;
    }

    public int pickaxeLevel() {
        return this.pickaxeLevel;
    }

    public void pickaxeLevel(int pickaxeLevel) {
        this.pickaxeLevel = pickaxeLevel;
    }

    public int pickaxeRanking() {
        return this.pickaxeRanking;
    }

    public void pickaxeRanking(int pickaxeRanking) {
        this.pickaxeRanking = pickaxeRanking;
    }

    public int savedPickaxeRanking() {
        return this.savedPickaxeRanking;
    }

    public void savedPickaxeRanking(int savedPickaxeRanking) {
        this.savedPickaxeRanking = savedPickaxeRanking;
    }

    public String savedPickaxeRankingString() {
        return this.savedPickaxeRankingString;
    }

    public void savedPickaxeRankingString(String savedPickaxeRankingString) {
        this.savedPickaxeRankingString = savedPickaxeRankingString;
    }

    public String pickaxeBoosterChance() {
        return this.pickaxeBoosterChance;
    }

    public void pickaxeBoosterChance(String pickaxeBoosterChance) {
        this.pickaxeBoosterChance = pickaxeBoosterChance;
    }

    public int brokenBlocks() {
        return this.brokenBlocks;
    }

    public void brokenBlocks(int brokenBlocks) {
        this.brokenBlocks = brokenBlocks;
    }

    public int sessionBlocks() {
        return this.sessionBlocks;
    }

    public void sessionBlocks(int sessionBlocks) {
        this.sessionBlocks = sessionBlocks;
    }

    public int currentBrokenBlocks() {
        return this.currentBrokenBlocks;
    }

    public void currentBrokenBlocks(int currentBrokenBlocks) {
        this.currentBrokenBlocks = currentBrokenBlocks;
    }

    public int breakGoalBlocks() {
        return this.breakGoalBlocks;
    }

    public void breakGoalBlocks(int breakGoalBlocks) {
        this.breakGoalBlocks = breakGoalBlocks;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public int workerCount() {
        return this.workerCount;
    }

    public void workerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public String nextWorkerCost() {
        return this.nextWorkerCost;
    }

    public void nextWorkerCost(String nextWorkerCost) {
        this.nextWorkerCost = nextWorkerCost;
    }

    public String debrisCost() {
        return this.debrisCost;
    }

    public void debrisCost(String debrisCost) {
        this.debrisCost = debrisCost;
    }

    public int savedSwordRanking() {
        return this.savedSwordRanking;
    }

    public void savedSwordRanking(int savedSwordRanking) {
        this.savedSwordRanking = savedSwordRanking;
    }

    public int swordRanking() {
        return this.swordRanking;
    }

    public void swordRanking(int swordRanking) {
        this.swordRanking = swordRanking;
    }

    public int swordMobs() {
        return this.swordMobs;
    }

    public void swordMobs(int swordMobs) {
        this.swordMobs = swordMobs;
    }

    public int mobKills() {
        return this.mobKills;
    }

    public void mobKills(int mobKills) {
        this.mobKills = mobKills;
    }

    public int sessionKills() {
        return this.sessionKills;
    }

    public void sessionKills(int sessionKills) {
        this.sessionKills = sessionKills;
    }

    public int debrisTime() {
        return this.debrisTime;
    }

    public void debrisTime(int debrisTime) {
        this.debrisTime = debrisTime;
    }

    public boolean workerNotifySent() {
        return this.workerNotifySent;
    }

    public void workerNotifySent(boolean workerNotifySent) {
        this.workerNotifySent = workerNotifySent;
    }

    public boolean debrisNotifySent() {
        return this.debrisNotifySent;
    }

    public void debrisNotifySent(boolean debrisNotifySent) {
        this.debrisNotifySent = debrisNotifySent;
    }

    public MineType mineByTranslation(String mineName) {
        MineType mine = null;
        for (MineType mines : MineType.values()) {
            if (!I18n.translate((String)mines.translation(), (Object[])new Object[0]).equals(mineName)) continue;
            mine = mines;
        }
        return mine;
    }

    public FarmingCave caveByName(String internalName) {
        FarmingCave cave = FarmingCave.UNKNOWN;
        for (FarmingCave miningCaves : FarmingCave.values()) {
            if (!miningCaves.internalName().equals(internalName)) continue;
            cave = miningCaves;
        }
        return cave;
    }

    public MoneyMakerEvent eventByName(String internalName) {
        MoneyMakerEvent event = MoneyMakerEvent.NONE;
        for (MoneyMakerEvent events : MoneyMakerEvent.values()) {
            if (!events.internalName().equals(internalName)) continue;
            event = events;
        }
        return event;
    }

    public static enum MoneyMakerEvent {
        NONE("none"),
        VALENTINE("valentine"),
        EASTER("easter"),
        SUMMER("summer"),
        CARIBBEAN("caribbean"),
        HALLOWEEN("halloween"),
        CHRISTMAS("christmas");

        private final String internalName;

        private MoneyMakerEvent(String internalName) {
            this.internalName = internalName;
        }

        public String internalName() {
            return this.internalName;
        }
    }

    public static class MoneyMakerJoinMessage {
        String message;
        String url;
        boolean priority;

        public MoneyMakerJoinMessage(String message, String url, boolean priority) {
            this.message = message;
            this.url = url;
            this.priority = priority;
        }

        public String getMessage() {
            return this.message;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isPriority() {
            return this.priority;
        }
    }

    public static enum FarmingCave {
        GOLD("Gold", "moneymaker.farming-level.gold", 198.0f, 255.0f),
        COAL("Coal", "moneymaker.farming-level.coal", 160.0f, 198.0f),
        IRON("Iron", "moneymaker.farming-level.iron", 0.0f, 160.0f),
        UNKNOWN("Unknown", "moneymaker.farming-level.unknown", 0.0f, 0.0f);

        private final String internalName;
        private final String translation;
        private float minY;
        private float maxY;

        private FarmingCave(String internalName, String translation, float minY, float maxY) {
            this.internalName = internalName;
            this.translation = translation;
            this.minY = minY;
            this.maxY = maxY;
        }

        public String internalName() {
            return this.internalName;
        }

        public String translation() {
            return this.translation;
        }

        public float minY() {
            return this.minY;
        }

        public float maxY() {
            return this.maxY;
        }

        public void minY(float minY) {
            this.minY = minY;
        }

        public void maxY(float maxY) {
            this.maxY = maxY;
        }
    }

    public static enum MineType {
        GOLD("Gold Mine", "moneymaker.mineType.gold"),
        COAL("Coal Mine", "moneymaker.mineType.coal"),
        IRON("Iron Mine", "moneymaker.mineType.iron"),
        LAPIS("Lapis Mine", "moneymaker.mineType.lapis");

        private final String internalName;
        private final String translation;

        private MineType(String internalName, String translation) {
            this.internalName = internalName;
            this.translation = translation;
        }

        public String internalName() {
            return this.internalName;
        }

        public String translation() {
            return this.translation;
        }
    }
}

