/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.PriceOverviewActivity;
import de.timuuuu.moneymaker.activities.widgets.LeaderboardEntryWidget;
import de.timuuuu.moneymaker.event.EventChatListener;
import de.timuuuu.moneymaker.event.EventHudWidget;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import de.timuuuu.moneymaker.settings.AddonSettings;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.types.GsonRequest;

public class ApiUtil {
    public static final String BASE_URL = "https://api.moneymakeraddon.de";
    private MoneyMakerAddon addon;

    public ApiUtil(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void loadSettings() {
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url("https://api.moneymakeraddon.de/settings", new Object[0])).async()).connectTimeout(5000)).readTimeout(5000)).userAgent("MoneyMaker LabyMod 4 Addon")).execute(response -> {
            JsonObject settingsObject;
            if (response.getStatusCode() != 200 || response.hasException()) {
                return;
            }
            JsonObject object = (JsonObject)response.get();
            if (object.has("joinMessage") && object.get("joinMessage").isJsonObject()) {
                JsonObject joinMessage = object.get("joinMessage").getAsJsonObject();
                this.addon.addonUtil().setJoinMessage(new AddonUtil.MoneyMakerJoinMessage(joinMessage.has("text") ? joinMessage.get("text").getAsString() : null, joinMessage.has("url") ? joinMessage.get("url").getAsString() : null, joinMessage.has("priority") && joinMessage.get("priority").getAsBoolean()));
            }
            if (object.has("availableLanguages") && object.get("availableLanguages").isJsonArray()) {
                object.get("availableLanguages").getAsJsonArray().forEach(jsonElement -> {
                    JsonObject languageObject;
                    if (jsonElement.isJsonObject() && (languageObject = jsonElement.getAsJsonObject()).has("name") && languageObject.has("language")) {
                        this.addon.chatMessageLoader().availableLanguages.put(languageObject.get("name").getAsString(), languageObject.get("language").getAsString());
                    }
                });
            }
            if (object.has("ignoredRankingValues") && object.get("ignoredRankingValues").isJsonArray()) {
                object.get("ignoredRankingValues").getAsJsonArray().forEach(jsonElement -> {
                    if (jsonElement.isJsonPrimitive()) {
                        this.addon.addonUtil().ignoredRankingValues().add(jsonElement.getAsString());
                    }
                });
            }
            if (object.has("settings") && object.get("settings").isJsonObject() && (settingsObject = object.get("settings").getAsJsonObject()).has("event")) {
                AddonUtil.MoneyMakerEvent event = this.addon.addonUtil().eventByName(settingsObject.get("event").getAsString());
                this.addon.addonUtil().currentEvent(event);
                if (event != AddonUtil.MoneyMakerEvent.NONE) {
                    this.addon.logger().info((CharSequence)("[MoneyMaker - Event] Loaded Event Type '" + String.valueOf((Object)event) + "' as current Event"), new Object[0]);
                    this.addon.labyAPI().eventBus().registerListener((Object)new EventChatListener(this.addon));
                    this.addon.labyAPI().minecraft().executeOnRenderThread(() -> this.addon.labyAPI().hudWidgetRegistry().register((Object)new EventHudWidget(this.addon)));
                }
            }
            if (object.has("prices") && object.get("prices").isJsonObject()) {
                JsonObject lapisMineObject;
                JsonObject ironMineObject;
                JsonObject coalMineObject;
                JsonArray array;
                ArrayList<String> workers;
                String cost;
                JsonObject goldmineObject;
                JsonObject pricesObject = object.get("prices").getAsJsonObject();
                if (pricesObject.has("Goldmine") && pricesObject.get("Goldmine").isJsonObject() && (goldmineObject = pricesObject.get("Goldmine").getAsJsonObject()).has("cost") && goldmineObject.has("workers")) {
                    cost = goldmineObject.get("cost").getAsString();
                    workers = new ArrayList<String>();
                    if (goldmineObject.get("workers").isJsonArray()) {
                        array = goldmineObject.get("workers").getAsJsonArray();
                        array.forEach(jsonElement -> {
                            JsonObject workerObject;
                            if (jsonElement.isJsonObject() && (workerObject = jsonElement.getAsJsonObject()).has("name") && workerObject.has("costs")) {
                                workers.add(workerObject.get("name").getAsString() + ";" + workerObject.get("costs").getAsString());
                            }
                        });
                    }
                    this.addon.priceOverviewActivity().priceData().put("Goldmine", new PriceOverviewActivity.MineData(cost, workers));
                }
                if (pricesObject.has("Kohlemine") && pricesObject.get("Kohlemine").isJsonObject() && (coalMineObject = pricesObject.get("Kohlemine").getAsJsonObject()).has("cost") && coalMineObject.has("workers")) {
                    cost = coalMineObject.get("cost").getAsString();
                    workers = new ArrayList();
                    if (coalMineObject.get("workers").isJsonArray()) {
                        array = coalMineObject.get("workers").getAsJsonArray();
                        array.forEach(jsonElement -> {
                            JsonObject workerObject;
                            if (jsonElement.isJsonObject() && (workerObject = jsonElement.getAsJsonObject()).has("name") && workerObject.has("costs")) {
                                workers.add(workerObject.get("name").getAsString() + ";" + workerObject.get("costs").getAsString());
                            }
                        });
                    }
                    this.addon.priceOverviewActivity().priceData().put("Kohlemine", new PriceOverviewActivity.MineData(cost, workers));
                }
                if (pricesObject.has("Eisenmine") && pricesObject.get("Eisenmine").isJsonObject() && (ironMineObject = pricesObject.get("Eisenmine").getAsJsonObject()).has("cost") && ironMineObject.has("workers")) {
                    cost = ironMineObject.get("cost").getAsString();
                    workers = new ArrayList();
                    if (ironMineObject.get("workers").isJsonArray()) {
                        array = ironMineObject.get("workers").getAsJsonArray();
                        array.forEach(jsonElement -> {
                            JsonObject workerObject;
                            if (jsonElement.isJsonObject() && (workerObject = jsonElement.getAsJsonObject()).has("name") && workerObject.has("costs")) {
                                workers.add(workerObject.get("name").getAsString() + ";" + workerObject.get("costs").getAsString());
                            }
                        });
                    }
                    this.addon.priceOverviewActivity().priceData().put("Eisenmine", new PriceOverviewActivity.MineData(cost, workers));
                }
                if (pricesObject.has("Lapismine") && pricesObject.get("Lapismine").isJsonObject() && (lapisMineObject = pricesObject.get("Lapismine").getAsJsonObject()).has("cost") && lapisMineObject.has("workers")) {
                    cost = lapisMineObject.get("cost").getAsString();
                    workers = new ArrayList();
                    if (lapisMineObject.get("workers").isJsonArray()) {
                        array = lapisMineObject.get("workers").getAsJsonArray();
                        array.forEach(jsonElement -> {
                            JsonObject workerObject;
                            if (jsonElement.isJsonObject() && (workerObject = jsonElement.getAsJsonObject()).has("name") && workerObject.has("costs")) {
                                workers.add(workerObject.get("name").getAsString() + ";" + workerObject.get("costs").getAsString());
                            }
                        });
                    }
                    this.addon.priceOverviewActivity().priceData().put("Lapismine", new PriceOverviewActivity.MineData(cost, workers));
                }
            }
        });
    }

    public void loadCoordinates() {
        AtomicBoolean failed = new AtomicBoolean(false);
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url("https://api.moneymakeraddon.de/locations", new Object[0])).async()).connectTimeout(5000)).readTimeout(5000)).userAgent("MoneyMaker LabyMod 4 Addon")).execute(response -> {
            JsonArray array;
            if (response.getStatusCode() != 200 || response.hasException()) {
                this.addon.addonSettings().setFallbackCoordinates(true);
                return;
            }
            JsonObject object = (JsonObject)response.get();
            if (object.has("workers") && object.get("workers").isJsonArray()) {
                array = object.get("workers").getAsJsonArray();
                array.forEach(jsonElement -> {
                    if (jsonElement.isJsonObject()) {
                        JsonObject workerObject = jsonElement.getAsJsonObject();
                        if (workerObject.has("x")) {
                            AddonSettings.workerCoordinates.get("x").add(workerObject.get("x").getAsDouble());
                        }
                        if (workerObject.has("z")) {
                            AddonSettings.workerCoordinates.get("z").add(workerObject.get("z").getAsDouble());
                        }
                    }
                });
                this.addon.logger().debug((CharSequence)"[MoneyMaker] Loaded Worker Coordinates from API.", new Object[0]);
            } else {
                failed.set(true);
            }
            if (object.has("debris") && object.get("debris").isJsonArray()) {
                array = object.get("debris").getAsJsonArray();
                array.forEach(jsonElement -> {
                    if (jsonElement.isJsonObject()) {
                        JsonObject workerObject = jsonElement.getAsJsonObject();
                        if (workerObject.has("x")) {
                            AddonSettings.debrisCoordinates.get("x").add(workerObject.get("x").getAsDouble());
                        }
                        if (workerObject.has("z")) {
                            AddonSettings.debrisCoordinates.get("z").add(workerObject.get("z").getAsDouble());
                        }
                    }
                });
                this.addon.logger().debug((CharSequence)"[MoneyMaker] Loaded Debris Coordinates from API.", new Object[0]);
            } else {
                failed.set(true);
            }
            if (object.has("cave_levels") && object.get("cave_levels").isJsonArray()) {
                array = object.get("cave_levels").getAsJsonArray();
                array.forEach(jsonElement -> {
                    AddonUtil.FarmingCave cave;
                    JsonObject levelObject;
                    if (jsonElement.isJsonObject() && (levelObject = jsonElement.getAsJsonObject()).has("name") && levelObject.has("min") && levelObject.has("max") && (cave = this.addon.addonUtil().caveByName(levelObject.get("name").getAsString())) != AddonUtil.FarmingCave.UNKNOWN) {
                        cave.minY(levelObject.get("min").getAsFloat());
                        cave.maxY(levelObject.get("max").getAsFloat());
                    }
                });
                this.addon.logger().debug((CharSequence)"[MoneyMaker] Loaded Cave Levels from API.", new Object[0]);
            }
        });
        if (failed.get()) {
            this.addon.addonSettings().setFallbackCoordinates(true);
        }
    }

    public void loadChatHistory() {
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.loadChatHistory().get()).booleanValue()) {
            return;
        }
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonArray.class).url("https://api.moneymakeraddon.de/chat/history", new Object[0])).async()).connectTimeout(5000)).readTimeout(5000)).userAgent("MoneyMaker LabyMod 4 Addon")).execute(response -> {
            if (response.getStatusCode() != 200 || response.hasException()) {
                this.addon.pushNotification((Component)Component.text((String)"Chat History", (TextColor)NamedTextColor.DARK_RED), (Component)Component.text((String)"Failed to load Chat History from Server", (TextColor)NamedTextColor.RED));
                this.addon.logger().error((CharSequence)"Chat Server Message History Error: ", (Throwable)response.exception());
                return;
            }
            JsonArray array = (JsonArray)response.get();
            ArrayList messages = new ArrayList();
            array.forEach(jsonElement -> {
                JsonObject object;
                if (jsonElement.isJsonObject() && (object = jsonElement.getAsJsonObject()).has("UUID") && object.has("UserName") && object.has("Message") && object.has("Rank") && object.has("MessageID") && object.has("formatted_timestamp") && !object.get("MessageID").getAsString().isEmpty()) {
                    JsonObject chatMessage = new JsonObject();
                    chatMessage.addProperty("messageId", object.get("MessageID").getAsString());
                    chatMessage.addProperty("uuid", object.get("UUID").getAsString());
                    chatMessage.addProperty("userName", object.get("UserName").getAsString());
                    chatMessage.addProperty("message", object.get("Message").getAsString());
                    chatMessage.addProperty("rank", object.get("Rank").getAsString());
                    chatMessage.addProperty("fromCache", Boolean.valueOf(true));
                    chatMessage.addProperty("timeStamp", object.get("formatted_timestamp").getAsString());
                    chatMessage.addProperty("addonVersion", object.has("AddonVersion") ? object.get("AddonVersion").getAsString() : "N/A");
                    chatMessage.addProperty("minecraftVersion", object.has("MinecraftVersion") ? object.get("MinecraftVersion").getAsString() : "N/A");
                    messages.add(MoneyChatMessage.fromJson(chatMessage));
                }
            });
            if (!messages.isEmpty()) {
                Collections.reverse(messages);
                messages.forEach(message -> this.addon.chatActivity().addChatMessage((MoneyChatMessage)message));
            }
        });
    }

    public void loadLeaderboard(boolean update) {
        this.addon.leaderboardActivity().entries().clear();
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonArray.class).url("https://api.moneymakeraddon.de/leaderboard", new Object[0])).async()).connectTimeout(5000)).readTimeout(5000)).userAgent("MoneyMaker LabyMod 4 Addon")).execute(response -> {
            if (response.getStatusCode() != 200 || response.hasException()) {
                this.addon.pushNotification((Component)Component.text((String)"Leaderboard", (TextColor)NamedTextColor.DARK_RED), (Component)Component.text((String)"Failed to load Leaderboard from Server", (TextColor)NamedTextColor.RED));
                this.addon.logger().error((CharSequence)"Leaderboard Error: ", (Throwable)response.exception());
                return;
            }
            JsonArray array = (JsonArray)response.get();
            array.forEach(jsonElement -> {
                JsonObject object;
                if (jsonElement.isJsonObject() && (object = jsonElement.getAsJsonObject()).has("UUID") && object.has("UserName") && object.has("Ranking") && object.has("Blocks") && object.has("Pickaxe_Ranking") && object.has("Sword_Ranking")) {
                    this.addon.labyAPI().minecraft().executeOnRenderThread(() -> this.addon.leaderboardActivity().entries().add(new LeaderboardEntryWidget(UUID.fromString(object.get("UUID").getAsString()), object.get("UserName").getAsString(), object.get("Ranking").getAsInt(), object.get("Blocks").getAsInt(), object.get("Pickaxe_Ranking").getAsInt(), object.get("Sword_Ranking").getAsInt(), object.get("LastUpdate").getAsString())));
                }
            });
            if (update) {
                this.addon.labyAPI().minecraft().executeOnRenderThread(() -> this.addon.leaderboardActivity().reload());
            }
        });
    }
}

