/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker;

import com.google.gson.Gson;
import de.timuuuu.moneymaker.activities.ChatActivity;
import de.timuuuu.moneymaker.activities.LeaderboardActivity;
import de.timuuuu.moneymaker.activities.PriceOverviewActivity;
import de.timuuuu.moneymaker.activities.StartActivity;
import de.timuuuu.moneymaker.activities.navigation.MainActivity;
import de.timuuuu.moneymaker.activities.navigation.MoneyMakerNavigationElement;
import de.timuuuu.moneymaker.activities.popup.TokenVerificationActivity;
import de.timuuuu.moneymaker.badges.MoneyChatPrefix;
import de.timuuuu.moneymaker.badges.MoneyIconTag;
import de.timuuuu.moneymaker.badges.MoneyTabBadge;
import de.timuuuu.moneymaker.badges.MoneyTextTag;
import de.timuuuu.moneymaker.boosters.BoosterUtil;
import de.timuuuu.moneymaker.commands.ResetCommand;
import de.timuuuu.moneymaker.commands.TimerCommand;
import de.timuuuu.moneymaker.commands.VerifyCommand;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.hudwidget.BalanceWidget;
import de.timuuuu.moneymaker.hudwidget.DebrisPriceWidget;
import de.timuuuu.moneymaker.hudwidget.DebrisTimerWidget;
import de.timuuuu.moneymaker.hudwidget.TimerDisplayWidget;
import de.timuuuu.moneymaker.hudwidget.WorkerCountWidget;
import de.timuuuu.moneymaker.hudwidget.WorkerPriceWidget;
import de.timuuuu.moneymaker.hudwidget.farming.ActivatedBoosterWidget;
import de.timuuuu.moneymaker.hudwidget.farming.BlockSessionWidget;
import de.timuuuu.moneymaker.hudwidget.farming.BoosterCountWidget;
import de.timuuuu.moneymaker.hudwidget.farming.BreakGoalWidget;
import de.timuuuu.moneymaker.hudwidget.farming.KillCountWidget;
import de.timuuuu.moneymaker.hudwidget.farming.LatestBoosterDisplayWidget;
import de.timuuuu.moneymaker.hudwidget.farming.SwordStatsWidget;
import de.timuuuu.moneymaker.listener.ChatReceiveListener;
import de.timuuuu.moneymaker.listener.EntityRenderListener;
import de.timuuuu.moneymaker.listener.InventoryListener;
import de.timuuuu.moneymaker.listener.MoneyAddonListener;
import de.timuuuu.moneymaker.listener.NetworkPayloadListener;
import de.timuuuu.moneymaker.listener.ScoreBoardListener;
import de.timuuuu.moneymaker.listener.TickListener;
import de.timuuuu.moneymaker.moneychat.MoneyChatClient;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.settings.AddonSettings;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.ApiUtil;
import de.timuuuu.moneymaker.utils.ChatMessageLoader;
import de.timuuuu.moneymaker.utils.CurrencyUtil;
import de.timuuuu.moneymaker.utils.DiscordAPI;
import de.timuuuu.moneymaker.utils.MoneyTextures;
import de.timuuuu.moneymaker.utils.Util;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.badge.renderer.BadgeRenderer;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.client.gui.hud.binding.category.HudWidgetCategory;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.notification.Notification;
import net.labymod.api.revision.Revision;
import net.labymod.api.revision.SimpleRevision;
import net.labymod.api.util.GsonUtil;
import net.labymod.api.util.version.SemanticVersion;

@AddonMain
public class MoneyMakerAddon
extends LabyAddon<MoneyMakerConfiguration> {
    public static final HudWidgetCategory CATEGORY = new HudWidgetCategory("moneymaker");
    public Component prefix = ((TextComponent)Component.text((String)"\u2016 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"MoneyMaker ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"\u00bb ", (TextColor)NamedTextColor.DARK_GRAY));
    private MoneyChatClient moneyChatClient;
    private MainActivity mainActivity;
    private PriceOverviewActivity priceOverviewActivity;
    private LeaderboardActivity leaderboardActivity;
    private ChatActivity chatActivity;
    private StartActivity startActivity;
    private TokenVerificationActivity tokenVerificationActivity;
    private DiscordAPI discordAPI;
    private ApiUtil apiUtil;
    private AddonSettings addonSettings;
    private AddonUtil addonUtil;
    private ChatMessageLoader chatMessageLoader;
    private EntityRenderListener entityRenderListener;
    private Gson gson;
    private static MoneyMakerAddon instance;

    protected void preConfigurationLoad() {
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("moneymaker", new SemanticVersion("1.6.7"), "2025-03-31"));
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("moneymaker", new SemanticVersion("1.7.0"), "2025-09-15"));
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("moneymaker", new SemanticVersion("1.7.1"), "2025-09-29"));
    }

    protected void enable() {
        this.registerSettingCategory();
        instance = this;
        new GroupService().loadGroups();
        this.discordAPI = new DiscordAPI(this);
        this.apiUtil = new ApiUtil(this);
        this.addonSettings = new AddonSettings();
        this.addonUtil = new AddonUtil(this);
        this.chatMessageLoader = new ChatMessageLoader();
        this.startActivity = new StartActivity(this);
        this.priceOverviewActivity = new PriceOverviewActivity(this);
        this.leaderboardActivity = new LeaderboardActivity(this);
        this.chatActivity = new ChatActivity(this);
        this.mainActivity = new MainActivity(this);
        this.tokenVerificationActivity = new TokenVerificationActivity(this);
        this.moneyChatClient = new MoneyChatClient(this, this.labyAPI().minecraft().sessionAccessor(), this.labyAPI().eventBus());
        this.moneyChatClient.prepareAsync();
        this.gson = GsonUtil.DEFAULT_GSON;
        this.apiUtil.loadSettings();
        this.registerCommand(new TimerCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new VerifyCommand(this));
        this.registerListener(new NetworkPayloadListener(this));
        this.registerListener(new ChatReceiveListener(this));
        this.registerListener(new MoneyAddonListener(this));
        this.registerListener(new ScoreBoardListener(this));
        this.entityRenderListener = new EntityRenderListener(this);
        this.registerListener(this.entityRenderListener);
        this.registerListener(new TickListener(this));
        this.registerListener(new InventoryListener(this));
        CurrencyUtil.setUnits();
        BoosterUtil.loadData();
        this.labyAPI().navigationService().register("moneymaker_main_ui", (Object)new MoneyMakerNavigationElement(this));
        this.labyAPI().hudWidgetRegistry().categoryRegistry().register((Object)CATEGORY);
        this.labyAPI().hudWidgetRegistry().register((Object)new BoosterCountWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new BlockSessionWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new BreakGoalWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new BalanceWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new WorkerCountWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new DebrisPriceWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new DebrisTimerWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new WorkerPriceWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new SwordStatsWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new KillCountWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new TimerDisplayWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new LatestBoosterDisplayWidget(this));
        this.labyAPI().hudWidgetRegistry().register((Object)new ActivatedBoosterWidget(this));
        this.labyAPI().tagRegistry().registerAfter("labymod_role", "moneymaker_text", PositionType.ABOVE_NAME, (TagRenderer)new MoneyTextTag(this));
        this.labyAPI().tagRegistry().register("moneymaker_icon", PositionType.RIGHT_TO_NAME, (TagRenderer)new MoneyIconTag(this));
        Laby.references().badgeRegistry().register("moneymaker_tab_icon", net.labymod.api.client.entity.player.badge.PositionType.LEFT_TO_NAME, (BadgeRenderer)new MoneyTabBadge(this));
        this.labyAPI().chatProvider().prefixRegistry().register("moneymaker_icon", (Object)new MoneyChatPrefix(this));
        this.logger().info((CharSequence)"Enabled the Addon", new Object[0]);
        this.addonSettings.setFallbackCoordinates(false);
        this.addonSettings.selectUpdateMode((AddonSettings.UpdateMode)((Object)((MoneyMakerConfiguration)this.configuration()).updateMode().get()));
        this.apiUtil.loadCoordinates();
        this.apiUtil.loadLeaderboard(false);
        ((MoneyMakerConfiguration)this.configuration()).updateMode().addChangeListener((type, oldValue, newValue) -> this.addonSettings.selectUpdateMode((AddonSettings.UpdateMode)((Object)newValue)));
        ((MoneyMakerConfiguration)this.configuration()).chatConfiguration.showDetailedLocation().addChangeListener((type, oldValue, newValue) -> {
            if (this.moneyChatClient.isAuthenticated()) {
                this.moneyChatClient.sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.configuration()).chatConfiguration.hideOnlineStatus.get()));
            }
        });
        ((MoneyMakerConfiguration)this.configuration()).discordConfiguration.enabled().addChangeListener((type, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.discordAPI.update();
            } else {
                this.discordAPI.removeCustom();
            }
        });
    }

    protected Class<MoneyMakerConfiguration> configurationClass() {
        return MoneyMakerConfiguration.class;
    }

    public Gson gson() {
        return this.gson;
    }

    public static MoneyMakerAddon instance() {
        return instance;
    }

    public DiscordAPI discordAPI() {
        return this.discordAPI;
    }

    public ApiUtil apiUtil() {
        return this.apiUtil;
    }

    public AddonUtil addonUtil() {
        return this.addonUtil;
    }

    public ChatMessageLoader chatMessageLoader() {
        return this.chatMessageLoader;
    }

    public AddonSettings addonSettings() {
        return this.addonSettings;
    }

    public MainActivity mainActivity() {
        return this.mainActivity;
    }

    public PriceOverviewActivity priceOverviewActivity() {
        return this.priceOverviewActivity;
    }

    public LeaderboardActivity leaderboardActivity() {
        return this.leaderboardActivity;
    }

    public ChatActivity chatActivity() {
        return this.chatActivity;
    }

    public MoneyChatClient moneyChatClient() {
        return this.moneyChatClient;
    }

    public StartActivity startActivity() {
        return this.startActivity;
    }

    public TokenVerificationActivity tokenVerificationActivity() {
        return this.tokenVerificationActivity;
    }

    public EntityRenderListener entityRenderListener() {
        return this.entityRenderListener;
    }

    public void pushNotification(Component title, Component text) {
        Notification.Builder builder = Notification.builder().title(title).text(text).icon(MoneyTextures.Common.ICON).type(Notification.Type.SYSTEM);
        this.labyAPI().notificationController().push(builder.build());
    }

    public void pushNotification(Component title, Component text, Icon icon) {
        Notification.Builder builder = Notification.builder().title(title).text(text).icon(icon).type(Notification.Type.SYSTEM);
        this.labyAPI().notificationController().push(builder.build());
    }

    public static void pushNotification(Component title, Component text, Component buttonText, Runnable buttonAction) {
        Notification.Builder builder = Notification.builder().title(title).text(text).icon(MoneyTextures.Common.ICON).addButton(Notification.NotificationButton.of((Component)buttonText, (Runnable)buttonAction)).type(Notification.Type.SYSTEM);
        Laby.labyAPI().notificationController().push(builder.build());
    }

    public void pushNotification(Component title, Component text, Icon icon, Component buttonText, Runnable buttonAction) {
        Notification.Builder builder = Notification.builder().title(title).text(text).icon(icon).addButton(Notification.NotificationButton.of((Component)buttonText, (Runnable)buttonAction)).type(Notification.Type.SYSTEM);
        Laby.labyAPI().notificationController().push(builder.build());
    }

    public void sendServerUpdate(String gameMode) {
        if (!((Boolean)((MoneyMakerConfiguration)this.configuration()).showCustomGameSwitchNotifications().get()).booleanValue()) {
            return;
        }
        LabyConnectSession session = this.labyAPI().labyConnect().getSession();
        if (session == null) {
            return;
        }
        session.sendCurrentServer(this.labyAPI().serverController().getCurrentServerData(), gameMode, false);
    }
}

