/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.widgets;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.Util;
import java.util.UUID;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

public class LeaderboardEntryWidget
extends HorizontalListWidget {
    private MoneyMakerAddon addon;
    private UUID uuid;
    private String playerName;
    private int ranking;
    private int blocks;
    private int pickaxeRanking;
    private int swordRanking;

    public LeaderboardEntryWidget(MoneyMakerAddon addon, UUID uuid, String playerName, int ranking, int blocks, int pickaxeRanking, int swordRanking) {
        this.addon = addon;
        this.uuid = uuid;
        this.playerName = playerName;
        this.ranking = ranking;
        this.blocks = blocks;
        this.pickaxeRanking = pickaxeRanking;
        this.swordRanking = swordRanking;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        HorizontalListWidget userWidget = (HorizontalListWidget)new HorizontalListWidget().addId("user");
        userWidget.addEntry(new IconWidget(Icon.head((UUID)this.uuid)).addId("head"));
        TextComponent userName = Component.text((String)this.playerName);
        userName.clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + this.playerName)));
        userWidget.addEntry(ComponentWidget.component((Component)userName).addId("userName"));
        this.addEntry((Widget)userWidget);
        this.addEntry(ComponentWidget.component((Component)Component.text((String)Util.format(this.ranking))).addId("ranking"));
        this.addEntry(ComponentWidget.component((Component)Component.text((String)(this.blocks != -2 ? Util.format(this.blocks) : "-"))).addId("blocks"));
        this.addEntry(ComponentWidget.component((Component)Component.text((String)Util.format(this.pickaxeRanking))).addId("pickaxe-ranking"));
        this.addEntry(ComponentWidget.component((Component)Component.text((String)Util.format(this.swordRanking))).addId("sword-ranking"));
    }

    public String playerName() {
        return this.playerName;
    }

    public int ranking() {
        return this.ranking;
    }

    public int blocks() {
        return this.blocks;
    }

    public int pickaxeRanking() {
        return this.pickaxeRanking;
    }

    public int swordRanking() {
        return this.swordRanking;
    }
}

