/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.badges;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.gfx.pipeline.renderer.text.TextRenderer;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.util.Color;
import net.labymod.api.util.color.format.ColorFormat;
import org.jetbrains.annotations.Nullable;

public class MoneyTextTag
extends NameTag {
    private MoneyMakerAddon addon;
    @Nullable
    private Group group;

    public MoneyTextTag(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void begin(Entity entity) {
        this.group = this.visibleGroup(entity);
        super.begin(entity);
    }

    public void render(Stack stack, Entity entity) {
        if (this.group == null) {
            return;
        }
        int alpha = (int)((float)Laby.labyAPI().minecraft().options().getBackgroundColorWithOpacity(192) * 255.0f);
        TextRenderer renderer = Laby.references().textRendererProvider().getRenderer();
        TextComponent groupDisplayName = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"MoneyMaker-Addon", (TextColor)TextColor.color((int)((Color)((MoneyMakerConfiguration)this.addon.configuration()).badgeConfiguration.textColor().get()).get())))).append((Component)Component.space())).append((Component)Component.text((String)this.group.getTagName(), (TextColor)this.group.getTextColor()))).build();
        float width = renderer.getWidth((Component)groupDisplayName);
        renderer.render(stack.getProvider().getPose(), (Component)groupDisplayName, -width / 2.0f, 0.0f, -1, 0xF000F0, ColorFormat.ARGB32.pack(0, alpha), 4);
    }

    public float getScale() {
        return 0.5f;
    }

    public boolean isVisible() {
        return !this.entity.isCrouching() && this.visibleGroup(this.entity) != null;
    }

    private Group visibleGroup(Entity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        if (player.profile().getUniqueId() == null) {
            return null;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).enabled().get()).booleanValue()) {
            return null;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).badgeConfiguration.textTag().get()).booleanValue()) {
            return null;
        }
        if (!AddonUtil.playerStatus.containsKey(player.profile().getUniqueId())) {
            return null;
        }
        if (AddonUtil.playerStatus.get(player.profile().getUniqueId()) == null) {
            return null;
        }
        Group group = AddonUtil.playerStatus.get(player.profile().getUniqueId()).group();
        return group.getDisplayType() == Group.GroupDisplay.BOTH || group.getDisplayType() == Group.GroupDisplay.ABOVE_HEAD ? group : null;
    }
}

