/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.boosters;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.util.I18n;

public class Booster {
    private static LinkedList<Booster> boosterList = new LinkedList();
    private static List<Booster> latestFoundBoosters = new ArrayList<Booster>();
    public static AtomicInteger sessionBoost = new AtomicInteger(0);
    public static AtomicInteger sessionBoosters = new AtomicInteger();
    public static AtomicInteger activatedBoost = new AtomicInteger(0);
    private int boost;
    private int amount;
    private int time;
    private String farmDate = "";

    public static void insertLatestBooster(int boost, int time) {
        if (latestFoundBoosters.size() <= 10) {
            latestFoundBoosters.add(new Booster(boost, time));
        } else {
            int lastIndex = latestFoundBoosters.size() - 1;
            latestFoundBoosters.remove(lastIndex);
            latestFoundBoosters.add(new Booster(boost, time));
        }
    }

    public static void insertBooster(int boost, int time) {
        for (Booster booster : boosterList) {
            if (booster.boost() != boost || booster.time() != time) continue;
            booster.addAmount();
            return;
        }
        String CURRENT_TIME = new SimpleDateFormat("dd.MM HH:mm").format(new Date());
        for (int i = 0; i < boosterList.size(); ++i) {
            if (boosterList.get(i).boost() < boost) {
                boosterList.add(i, new Booster(boost, time, CURRENT_TIME));
                return;
            }
            if (boosterList.get(i).boost() != boost || boosterList.get(i).time() >= time) continue;
            boosterList.add(i, new Booster(boost, time, CURRENT_TIME));
            return;
        }
        boosterList.add(new Booster(boost, time, CURRENT_TIME));
    }

    public static LinkedList<Booster> boosterList() {
        return boosterList;
    }

    public static List<Booster> latestFoundBoosters() {
        return latestFoundBoosters;
    }

    public Booster(int boost, int time) {
        this.boost = boost;
        this.amount = 1;
        this.time = time;
    }

    public Booster(int boost, int time, String farmDate) {
        this.boost = boost;
        this.amount = 1;
        this.time = time;
        this.farmDate = farmDate;
    }

    public int boost() {
        return this.boost;
    }

    public int time() {
        return this.time;
    }

    public String farmDate() {
        return this.farmDate;
    }

    public int amount() {
        return this.amount;
    }

    public void addAmount() {
        ++this.amount;
    }

    public String readableTime() {
        int hours;
        int tempTime = this.time;
        String boosterTime = tempTime > 59 ? (tempTime == 90 ? "90 " + I18n.translate((String)"moneymaker.text.timeUnit.minutes", (Object[])new Object[0]) : hours + " " + I18n.translate((String)("moneymaker.text.timeUnit." + ((hours = this.time / 60) == 1 ? "hour" : "hours")), (Object[])new Object[0])) : this.time + " " + I18n.translate((String)"moneymaker.text.timeUnit.minutes", (Object[])new Object[0]);
        return boosterTime;
    }

    public String toExport() {
        return this.amount + "x;" + this.boost + ";(" + this.readableTime() + ")";
    }
}

