/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.CurrencyUtil;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.util.I18n;

@SpriteSlot(x=2)
public class DebrisPriceWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private MoneyMakerAddon addon;
    private TextLine textLine;

    public DebrisPriceWidget(MoneyMakerAddon addon) {
        super("mm_debris_price");
        this.addon = addon;
        this.bindCategory(MoneyMakerAddon.CATEGORY);
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.textLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_debris_price.name", (Component[])new Component[0]), "0");
    }

    public void onTick(boolean isEditorContext) {
        Object itemName = "N/A";
        if (this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.addonUtil().balance().equals("X") && !this.addon.addonUtil().debrisCost().equals("X")) {
            if (this.addon.addonUtil().nextWorkerCost().equals("X")) {
                String[] kontoSplit = this.addon.addonUtil().balance().split(" ");
                if (kontoSplit.length > 1) {
                    String balanceUnit = kontoSplit[1];
                    String debrisUnit = this.addon.addonUtil().debrisCost().split(" ")[1];
                    double balance = Double.parseDouble(this.addon.addonUtil().balance().replaceAll("[^\\d.]", ""));
                    double cost = Double.parseDouble(this.addon.addonUtil().debrisCost().replaceAll("[^\\d.]", ""));
                    int difference = Double.compare(balance, cost);
                    String color = "\u00a7c";
                    if (CurrencyUtil.get(balanceUnit) > CurrencyUtil.get(debrisUnit)) {
                        color = "\u00a7a\u00a7l";
                    } else if (CurrencyUtil.get(balanceUnit) == CurrencyUtil.get(debrisUnit)) {
                        color = difference >= 0 ? "\u00a7a" : "\u00a76";
                    }
                    itemName = color + this.addon.addonUtil().balance() + " / " + this.addon.addonUtil().debrisCost();
                } else {
                    itemName = "\u00a7c" + this.addon.addonUtil().balance() + " / " + this.addon.addonUtil().debrisCost();
                }
            } else {
                itemName = I18n.translate((String)"moneymaker.hudWidget.mm_debris_price.unlock_last_miner", (Object[])new Object[0]);
            }
        }
        this.textLine.updateAndFlush(itemName);
        this.textLine.setState(this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.addonUtil().balance().equals("X") && !this.addon.addonUtil().debrisCost().equals("X") ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
    }
}

