/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.MoneyTimer;
import de.timuuuu.moneymaker.utils.Util;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.SimpleHudWidget;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.render.font.ComponentRenderer;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.util.Color;

public class TimerDisplayWidget
extends SimpleHudWidget<TimerHudWidgetConfig> {
    List<MoneyTimer> dummyTimers = new ArrayList<MoneyTimer>();
    private MoneyMakerAddon addon;

    public TimerDisplayWidget(MoneyMakerAddon addon) {
        super("mm_timer_display", TimerHudWidgetConfig.class);
        this.bindCategory(MoneyMakerAddon.CATEGORY);
        this.setIcon(Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)0, (int)2));
        this.addon = addon;
        this.dummyTimers.add(new MoneyTimer("Timer #1", 30));
        this.dummyTimers.add(new MoneyTimer("Timer #2", 10));
        this.dummyTimers.add(new MoneyTimer("Timer #3", 40));
    }

    public void render(SimpleHudWidget.RenderPhase renderPhase, ScreenContext context, boolean isEditorContext, HudSize size) {
        size.setHeight(0.0f);
        size.setWidth(0.0f);
        if (isEditorContext) {
            this.renderTimers(this.dummyTimers, context.stack(), size);
            return;
        }
        if (!this.addon.addonUtil().connectedToMoneyMaker()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_timer_display.notConnected", (Component[])new Component[0]), context.stack(), size);
            return;
        }
        ArrayList<MoneyTimer> timers = new ArrayList<MoneyTimer>(Util.timers.values());
        if (timers.isEmpty()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_timer_display.noTimers", (Component[])new Component[0]), context.stack(), size);
            return;
        }
        this.renderTimers(timers, context.stack(), size);
    }

    private void renderComponent(Component component, Stack stack, HudSize size) {
        RenderableComponent renderableComponent = RenderableComponent.of((Component)component);
        if (stack != null) {
            this.labyAPI.renderPipeline().componentRenderer().builder().text(renderableComponent).pos(1.0f, 1.0f).render(stack);
        }
        size.setWidth(renderableComponent.getWidth() + 2.0f);
        size.setHeight(renderableComponent.getHeight() + 2.0f);
    }

    private void renderTimers(List<MoneyTimer> timers, Stack stack, HudSize size) {
        ComponentRenderer componentRenderer = this.labyAPI.renderPipeline().componentRenderer();
        int x = 1;
        int y = 1;
        TranslatableComponent title = Component.translatable((String)"moneymaker.hudWidget.mm_timer_display.currentTimers", (TextColor)TextColor.color((int)((Color)((TimerHudWidgetConfig)this.config).textColor.get()).get()));
        RenderableComponent titleComponent = RenderableComponent.of((Component)title);
        if (stack != null) {
            componentRenderer.builder().text(titleComponent).pos((float)x, (float)y).render(stack);
        }
        size.setWidth((float)x + titleComponent.getWidth() + 1.0f);
        y += (int)(titleComponent.getHeight() + 1.0f);
        int rowHeight = (int)componentRenderer.height();
        int maxTimerIndex = (Integer)((TimerHudWidgetConfig)this.config).maxDisplayedTimers.get() - 1;
        int timerIndex = 0;
        for (MoneyTimer timer : timers) {
            if (timerIndex > maxTimerIndex) break;
            ++timerIndex;
            int timerX = x;
            if (stack != null) {
                Icon icon = Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)0, (int)2);
                icon.render(stack, (float)timerX, (float)y, (float)rowHeight);
            }
            timerX += rowHeight + 4;
            Component component = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)timer.name(), (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" [", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)(timer.minutes() + "m"), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"] \u00bb ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)timer.remainingTime(), (TextColor)NamedTextColor.YELLOW));
            RenderableComponent timerName = RenderableComponent.of((Component)component);
            if (stack != null) {
                componentRenderer.builder().text(timerName).pos((float)timerX, (float)y).render(stack);
            }
            y += (int)(timerName.getHeight() + 1.0f);
            size.setWidth(Math.max(size.getActualWidth(), (float)((timerX += (int)timerName.getWidth()) + 1)));
        }
        size.setHeight((float)y);
    }

    public boolean isVisibleInGame() {
        return this.addon.addonUtil().connectedToMoneyMaker() && !Util.timers.isEmpty();
    }

    public static class TimerHudWidgetConfig
    extends HudWidgetConfig {
        @ColorPickerWidget.ColorPickerSetting
        private final ConfigProperty<Color> textColor = new ConfigProperty((Object)Color.YELLOW);
        @SliderWidget.SliderSetting(min=2.0f, max=15.0f)
        private final ConfigProperty<Integer> maxDisplayedTimers = new ConfigProperty((Object)5);
    }
}

