/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.CurrencyUtil;
import de.timuuuu.moneymaker.utils.MoneyTextures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;

public class WorkerPriceWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private MoneyMakerAddon addon;
    private TextLine textLine;

    public WorkerPriceWidget(MoneyMakerAddon addon) {
        super("mm_worker_price");
        this.addon = addon;
        this.bindCategory(MoneyMakerAddon.CATEGORY);
        this.setIcon(MoneyTextures.Common.MINER);
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.textLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_worker_price.display", (Component[])new Component[0]), "0");
    }

    public void onTick(boolean isEditorContext) {
        Object itemName = "N/A";
        if (this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.addonUtil().balance().equals("X") && !this.addon.addonUtil().nextWorkerCost().equals("X")) {
            String[] kontoSplit = this.addon.addonUtil().balance().split(" ");
            if (kontoSplit.length > 1) {
                String balanceUnit = kontoSplit[1];
                String workerUnit = this.addon.addonUtil().nextWorkerCost().split(" ")[1];
                double balance = Double.parseDouble(this.addon.addonUtil().balance().replaceAll("[^\\d.]", ""));
                double cost = Double.parseDouble(this.addon.addonUtil().nextWorkerCost().replaceAll("[^\\d.]", ""));
                int difference = Double.compare(balance, cost);
                String color = "\u00a7c";
                if (CurrencyUtil.get(balanceUnit) > CurrencyUtil.get(workerUnit)) {
                    color = "\u00a7a\u00a7l";
                } else if (CurrencyUtil.get(balanceUnit) == CurrencyUtil.get(workerUnit)) {
                    color = difference >= 0 ? "\u00a7a" : "\u00a76";
                }
                itemName = color + this.addon.addonUtil().balance() + " / " + this.addon.addonUtil().nextWorkerCost();
            } else {
                itemName = "\u00a7c" + this.addon.addonUtil().balance() + " / " + this.addon.addonUtil().nextWorkerCost();
            }
        }
        this.textLine.updateAndFlush(itemName);
        this.textLine.setState(this.addon.addonUtil().connectedToMoneyMaker() && !this.addon.addonUtil().balance().equals("X") && !this.addon.addonUtil().nextWorkerCost().equals("X") ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
    }
}

