/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget.farming;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.boosters.BoosterUtil;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.SimpleHudWidget;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.render.font.ComponentRenderer;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.util.Color;

public class LatestBoosterDisplayWidget
extends SimpleHudWidget<BoosterHudWidgetConfig> {
    List<Booster> dummyBoosters = new ArrayList<Booster>();
    private MoneyMakerAddon addon;

    public LatestBoosterDisplayWidget(MoneyMakerAddon addon) {
        super("mm_booster_display", BoosterHudWidgetConfig.class);
        this.bindCategory(MoneyMakerAddon.CATEGORY);
        this.setIcon(Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)0, (int)0));
        this.addon = addon;
        this.dummyBoosters.add(new Booster(10, 15));
        this.dummyBoosters.add(new Booster(100, 30));
        this.dummyBoosters.add(new Booster(50, 60));
    }

    public void render(SimpleHudWidget.RenderPhase renderPhase, ScreenContext context, boolean isEditorContext, HudSize size) {
        size.setHeight(0.0f);
        size.setWidth(0.0f);
        if (isEditorContext) {
            this.renderBoosters(this.dummyBoosters, context.stack(), size);
            return;
        }
        if (!this.addon.addonUtil().inFarming() && !((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get()).booleanValue()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.notConnected", (Component[])new Component[0]), context.stack(), size);
            return;
        }
        ArrayList<Booster> boosters = new ArrayList<Booster>();
        for (int j = Booster.latestFoundBoosters().size() - 1; j >= 0; --j) {
            Booster booster = Booster.latestFoundBoosters().get(j);
            boosters.add(booster);
        }
        if (Booster.latestFoundBoosters().isEmpty()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.noBoosters", (Component[])new Component[0]), context.stack(), size);
            return;
        }
        this.renderBoosters(boosters, context.stack(), size);
    }

    private void renderComponent(Component component, Stack stack, HudSize size) {
        RenderableComponent renderableComponent = RenderableComponent.of((Component)component);
        if (stack != null) {
            this.labyAPI.renderPipeline().componentRenderer().builder().text(renderableComponent).pos(1.0f, 1.0f).render(stack);
        }
        size.setWidth(renderableComponent.getWidth() + 2.0f);
        size.setHeight(renderableComponent.getHeight() + 2.0f);
    }

    private void renderBoosters(List<Booster> boosters, Stack stack, HudSize size) {
        ComponentRenderer componentRenderer = this.labyAPI.renderPipeline().componentRenderer();
        int x = 1;
        int y = 1;
        TranslatableComponent title = Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.latestBoosters", (TextColor)TextColor.color((int)((Color)((BoosterHudWidgetConfig)this.config).textColor.get()).get()));
        RenderableComponent titleComponent = RenderableComponent.of((Component)title);
        if (stack != null) {
            componentRenderer.builder().text(titleComponent).pos((float)x, (float)y).render(stack);
        }
        size.setWidth((float)x + titleComponent.getWidth() + 1.0f);
        y += (int)(titleComponent.getHeight() + 1.0f);
        int rowHeight = (int)componentRenderer.height();
        int maxBoosterIndex = (Integer)((BoosterHudWidgetConfig)this.config).maxDisplayedBoosters.get() - 1;
        int boosterIndex = 0;
        for (Booster booster : boosters) {
            if (boosterIndex > maxBoosterIndex) break;
            ++boosterIndex;
            int timerX = x;
            if (stack != null) {
                BoosterUtil.getIcon(booster).render(stack, (float)timerX, (float)y, (float)rowHeight);
            }
            timerX += rowHeight + 4;
            Component component = ((TextComponent)Component.text((String)(booster.boost() + "%"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" \u2503 ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)booster.readableTime(), (TextColor)NamedTextColor.GRAY));
            RenderableComponent timerName = RenderableComponent.of((Component)component);
            if (stack != null) {
                componentRenderer.builder().text(timerName).pos((float)timerX, (float)y).render(stack);
            }
            y += (int)(timerName.getHeight() + 1.0f);
            size.setWidth(Math.max(size.getActualWidth(), (float)((timerX += (int)timerName.getWidth()) + 1)));
        }
        size.setHeight((float)y);
    }

    public boolean isVisibleInGame() {
        return (this.addon.addonUtil().inFarming() || (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() != false) && !Booster.latestFoundBoosters().isEmpty();
    }

    public static class BoosterHudWidgetConfig
    extends HudWidgetConfig {
        @ColorPickerWidget.ColorPickerSetting
        private final ConfigProperty<Color> textColor = new ConfigProperty((Object)Color.YELLOW);
        @SliderWidget.SliderSetting(min=2.0f, max=10.0f)
        private final ConfigProperty<Integer> maxDisplayedBoosters = new ConfigProperty((Object)5);
    }
}

