/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.event.ArmorStandRenderEvent;
import de.timuuuu.moneymaker.settings.AddonSettings;
import de.timuuuu.moneymaker.utils.ChatUtil;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.TimeUnit;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.event.Subscribe;
import net.labymod.api.util.concurrent.task.Task;

public class EntityRenderListener {
    private MoneyMakerAddon addon;
    private int checkCount = 0;
    private boolean timerRunning = false;
    private Task debrisTask;

    public EntityRenderListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onArmorStandRender(ArmorStandRenderEvent event) {
        if (!this.addon.addonUtil().inMine()) {
            return;
        }
        Entity entity = event.entity();
        ++this.checkCount;
        if (this.checkCount >= this.addon.addonSettings().CHECK_RENDER()) {
            this.checkCount = 0;
            String entityName = ChatUtil.stripColor(event.customName());
            if (entityName.contains("Kosten: ") || entityName.contains("Price: ")) {
                String costs = entityName.replace("Kosten: ", "").replace("Price: ", "");
                if ((AddonSettings.workerCoordinates.get("x").contains(entity.position().getX()) || AddonSettings.workerCoordinates.get("z").contains(entity.position().getZ())) && !this.addon.addonUtil().nextWorkerCost().equals(costs)) {
                    this.addon.addonUtil().nextWorkerCost(costs);
                }
                if ((AddonSettings.debrisCoordinates.get("x").contains(entity.position().getX()) || AddonSettings.debrisCoordinates.get("z").contains(entity.position().getZ())) && !this.addon.addonUtil().debrisCost().equals(costs)) {
                    this.addon.addonUtil().debrisCost(costs);
                }
            }
            if ((entityName.contains("Minen-Arbeitspl\u00e4tze") || entityName.contains("mining workplaces")) & entityName.contains("/")) {
                int count = Util.parseInteger(entityName.split("/")[0], this.getClass());
                if (this.addon.addonUtil().workerCount() != count) {
                    this.addon.addonUtil().workerCount(count);
                }
            }
            if (entityName.contains("Ger\u00f6ll entfernen ") || entityName.contains("Remove debris ")) {
                Object time = entityName.replace("Ger\u00f6ll entfernen ", "").replace("Remove debris ", "");
                if (((String)time).contains(" Stunde") && ((String)time).contains(" Minute") || ((String)time).contains(" hour") && ((String)time).contains(" minute")) {
                    time = ((String)time).replace(" Stunden", "").replace(" Stunde", "").replace(" hours", "").replace(" hours", "");
                    time = ((String)time).replace(" Minuten", "").replace(" Minute", "").replace(" minutes", "").replace(" minute", "");
                    time = ((String)time).replace(" ", ":");
                    time = (String)time + ":00";
                    if (this.addon.addonUtil().debrisTime() == 0 & !this.timerRunning) {
                        this.addon.addonUtil().debrisTime(Util.timeToInt((String)time, true));
                        this.startDebrisTask();
                    }
                } else if (this.addon.addonUtil().debrisTime() == 0 & !this.timerRunning) {
                    this.addon.addonUtil().debrisTime(Util.timeToInt((String)time, false));
                    this.startDebrisTask();
                }
            }
        }
    }

    private void startDebrisTask() {
        this.timerRunning = true;
        this.debrisTask = Task.builder(() -> {
            this.addon.addonUtil().debrisTime(this.addon.addonUtil().debrisTime() - 1);
            if (this.addon.addonUtil().debrisTime() <= 0) {
                this.debrisTask.cancel();
                this.timerRunning = false;
            }
        }).repeat(1L, TimeUnit.SECONDS).build();
        this.debrisTask.execute();
    }

    public void stopDebrisTask() {
        if (this.debrisTask == null) {
            return;
        }
        this.debrisTask.cancel();
        this.timerRunning = false;
        this.addon.addonUtil().debrisTime(0);
    }
}

