/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.event.EventUtil;
import de.timuuuu.moneymaker.event.InventoryClickEvent;
import de.timuuuu.moneymaker.event.InventoryCloseEvent;
import de.timuuuu.moneymaker.event.InventoryRenderSlotEvent;
import de.timuuuu.moneymaker.events.MineSwitchEvent;
import de.timuuuu.moneymaker.events.ProfileSwitchEvent;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.ChatUtil;
import de.timuuuu.moneymaker.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;

public class InventoryListener {
    private static List<SlotItem> alreadyRendered = new ArrayList<SlotItem>();
    private static int totalBoosters = 0;
    private int previousBoost = -1;
    private int previousTotalBoosters = -1;
    private long lastDisplayTime = 0L;
    private final long DISPLAY_COOLDOWN = 30000L;
    private String currentProfile = "";
    private MoneyMakerAddon addon;

    public InventoryListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onInventoryClick(InventoryClickEvent event) {
        JsonObject object;
        JsonElement element;
        if (event.getInventoryName().equals("Server wechseln") || event.getInventoryName().equals("Switch server")) {
            AddonUtil.MineType mineType;
            String mineName = null;
            if (event.textVersion() == EventUtil.TextVersion.RAW) {
                mineName = event.getItemName();
            } else {
                element = JsonParser.parseString((String)event.getItemName());
                if (element != null && element.isJsonObject() && (object = element.getAsJsonObject()).has("text")) {
                    mineName = object.get("text").getAsString();
                }
            }
            if (mineName != null && (mineType = this.addon.addonUtil().mineByTranslation(mineName)) != null && this.addon.addonUtil().currentMine() != mineType) {
                Laby.fireEvent((Event)new MineSwitchEvent(this.addon.addonUtil().currentMine(), mineType));
                this.addon.addonUtil().currentMine(mineType);
            }
        }
        if ((event.getInventoryName().equals("Profil-\u00dcbersicht") || event.getInventoryName().equals("Profile overview")) && (event.getItemName().contains("Profil-Slot") || event.getItemName().contains("Profile slot") || event.getItemName().contains("Event-Profil") || event.getItemName().contains("Event profile"))) {
            String newProfile = null;
            if (event.textVersion() == EventUtil.TextVersion.RAW) {
                newProfile = event.getItemName();
            } else {
                try {
                    element = JsonParser.parseString((String)event.getItemName());
                    if (element != null && element.isJsonObject() && (object = element.getAsJsonObject()).has("text")) {
                        newProfile = object.get("text").getAsString();
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            if (newProfile != null && !this.currentProfile.equals(newProfile)) {
                Laby.fireEvent((Event)new ProfileSwitchEvent(this.currentProfile, newProfile));
                this.currentProfile = newProfile;
            }
        }
    }

    public static void clearAlreadyRendered() {
        alreadyRendered.clear();
        totalBoosters = 0;
    }

    public int getBoost() {
        AtomicInteger boost = new AtomicInteger(0);
        if (!alreadyRendered.isEmpty()) {
            alreadyRendered.forEach(slotItem -> {
                String booster;
                String[] rawBooster;
                Object strippedName = null;
                if (slotItem.textVersion() == EventUtil.TextVersion.RAW) {
                    strippedName = ChatUtil.stripColor(slotItem.getName());
                } else {
                    List<String> rawName = Util.getTextFromJsonObject(slotItem.getName());
                    if (rawName.size() == 2) {
                        strippedName = rawName.get(0) + rawName.get(1);
                    }
                }
                if (strippedName != null && (rawBooster = (booster = ((String)strippedName).replace("+", "").replace(".", "").replace(",", "").replace("%", "").replace("Booster", "").replace("booster", "").replace(" ", "")).split("\\(")).length == 2) {
                    try {
                        int boosting = Util.parseInteger(rawBooster[0], this.getClass());
                        int amount = Util.parseInteger(rawBooster[1].replace(")", ""), this.getClass());
                        int finalBoost = boosting * amount;
                        boost.getAndAdd(finalBoost);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return boost.get();
    }

    @Subscribe
    public void onInventoryRenderSlot(InventoryRenderSlotEvent event) {
        String durationLore;
        String displayName;
        SlotItem slotItem;
        if (!event.getInventoryName().startsWith("Booster-\u00dcbersicht") && !event.getInventoryName().startsWith("Booster overview")) {
            return;
        }
        if (!event.getDisplayName().contains("Booster") && !event.getDisplayName().contains("booster")) {
            return;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showTotalBoostMessage().get()).booleanValue()) {
            return;
        }
        if (event.textVersion() == EventUtil.TextVersion.RAW) {
            String durationLore2;
            String displayName2;
            SlotItem slotItem2;
            if (event.getLoreList().size() >= 9 && !alreadyRendered.contains(slotItem2 = new SlotItem(displayName2 = event.getDisplayName(), durationLore2 = event.getLoreList().get(2), event.textVersion()))) {
                alreadyRendered.add(slotItem2);
            }
            return;
        }
        if (event.getLoreList().size() >= 9 && !alreadyRendered.contains(slotItem = new SlotItem(displayName = event.getDisplayName(), durationLore = event.getLoreList().get(2), event.textVersion()))) {
            alreadyRendered.add(slotItem);
        }
    }

    @Subscribe
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!event.getInventoryName().startsWith("Booster-\u00dcbersicht") && !event.getInventoryName().startsWith("Booster overview")) {
            return;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showTotalBoostMessage().get()).booleanValue()) {
            return;
        }
        String inventoryName = ChatUtil.stripColor(event.getInventoryName());
        String[] rawInvName = inventoryName.split("\\(");
        if (rawInvName.length == 2) {
            try {
                totalBoosters = Util.parseInteger(rawInvName[1].split("/")[0].replace(".", "").replace(",", ""), this.getClass());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int boost = this.getBoost();
        long currentTime = System.currentTimeMillis();
        if (boost > 0 && totalBoosters > 0 && (boost != this.previousBoost || totalBoosters != this.previousTotalBoosters || currentTime - this.lastDisplayTime >= 30000L)) {
            this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.text.booster.inventory.total", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)Util.format(totalBoosters), (TextColor)NamedTextColor.YELLOW), Component.text((String)(Util.format(boost) + "%"), (TextColor)NamedTextColor.YELLOW)})).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"moneymaker.text.booster.inventory.info", (TextColor)NamedTextColor.GRAY))));
            this.previousBoost = boost;
            this.previousTotalBoosters = totalBoosters;
            this.lastDisplayTime = currentTime;
        }
        InventoryListener.clearAlreadyRendered();
    }

    private static class SlotItem {
        private String name;
        private String lore;
        private EventUtil.TextVersion textVersion;

        public SlotItem(String name, String lore, EventUtil.TextVersion textVersion) {
            this.name = name;
            this.lore = lore;
            this.textVersion = textVersion;
        }

        public String getName() {
            return this.name;
        }

        public String getLore() {
            return this.lore;
        }

        public EventUtil.TextVersion textVersion() {
            return this.textVersion;
        }

        public boolean equals(Object object) {
            if (object instanceof SlotItem) {
                SlotItem other = (SlotItem)object;
                return other.getName().equals(this.name) && other.getLore().equals(this.lore) && other.textVersion().equals((Object)this.textVersion);
            }
            return false;
        }
    }
}

